package software.amazon.awscdk.services.certificatemanager;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-20T13:02:58.587Z")
public interface DnsValidatedCertificateProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.certificatemanager.CertificateProps {
    /**
     * Route 53 Hosted Zone used to perform DNS validation of the request.  The zone
     * must be authoritative for the domain name specified in the Certificate Request.
     */
    software.amazon.awscdk.services.route53.IHostedZone getHostedZone();
    /**
     * Route 53 Hosted Zone used to perform DNS validation of the request.  The zone
     * must be authoritative for the domain name specified in the Certificate Request.
     */
    void setHostedZone(final software.amazon.awscdk.services.route53.IHostedZone value);

    /**
     * @return a {@link Builder} of {@link DnsValidatedCertificateProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link DnsValidatedCertificateProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.route53.IHostedZone _hostedZone;
        private java.lang.String _domainName;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _subjectAlternativeNames;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _validationDomains;

        /**
         * Sets the value of HostedZone
         * @param value Route 53 Hosted Zone used to perform DNS validation of the request.  The zone
must be authoritative for the domain name specified in the Certificate Request.
         * @return {@code this}
         */
        public Builder withHostedZone(final software.amazon.awscdk.services.route53.IHostedZone value) {
            this._hostedZone = java.util.Objects.requireNonNull(value, "hostedZone is required");
            return this;
        }
        /**
         * Sets the value of DomainName
         * @param value Fully-qualified domain name to request a certificate for.

May contain wildcards, such as ``*.domain.com``.
         * @return {@code this}
         */
        public Builder withDomainName(final java.lang.String value) {
            this._domainName = java.util.Objects.requireNonNull(value, "domainName is required");
            return this;
        }
        /**
         * Sets the value of SubjectAlternativeNames
         * @param value Alternative domain names on your certificate.

Use this to register alternative domain names that represent the same site.
         * @return {@code this}
         */
        public Builder withSubjectAlternativeNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._subjectAlternativeNames = value;
            return this;
        }
        /**
         * Sets the value of ValidationDomains
         * @param value What validation domain to use for every requested domain.

Has to be a superdomain of the requested domain.
         * @return {@code this}
         */
        public Builder withValidationDomains(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._validationDomains = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DnsValidatedCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public DnsValidatedCertificateProps build() {
            return new DnsValidatedCertificateProps() {
                private software.amazon.awscdk.services.route53.IHostedZone $hostedZone = java.util.Objects.requireNonNull(_hostedZone, "hostedZone is required");
                private java.lang.String $domainName = java.util.Objects.requireNonNull(_domainName, "domainName is required");
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $subjectAlternativeNames = _subjectAlternativeNames;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.String> $validationDomains = _validationDomains;

                @Override
                public software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
                    return this.$hostedZone;
                }

                @Override
                public void setHostedZone(final software.amazon.awscdk.services.route53.IHostedZone value) {
                    this.$hostedZone = java.util.Objects.requireNonNull(value, "hostedZone is required");
                }

                @Override
                public java.lang.String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public void setDomainName(final java.lang.String value) {
                    this.$domainName = java.util.Objects.requireNonNull(value, "domainName is required");
                }

                @Override
                public java.util.List<java.lang.String> getSubjectAlternativeNames() {
                    return this.$subjectAlternativeNames;
                }

                @Override
                public void setSubjectAlternativeNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$subjectAlternativeNames = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
                    return this.$validationDomains;
                }

                @Override
                public void setValidationDomains(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$validationDomains = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Route 53 Hosted Zone used to perform DNS validation of the request.  The zone
         * must be authoritative for the domain name specified in the Certificate Request.
         */
        @Override
        public software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
            return this.jsiiGet("hostedZone", software.amazon.awscdk.services.route53.IHostedZone.class);
        }

        /**
         * Route 53 Hosted Zone used to perform DNS validation of the request.  The zone
         * must be authoritative for the domain name specified in the Certificate Request.
         */
        @Override
        public void setHostedZone(final software.amazon.awscdk.services.route53.IHostedZone value) {
            this.jsiiSet("hostedZone", java.util.Objects.requireNonNull(value, "hostedZone is required"));
        }

        /**
         * Fully-qualified domain name to request a certificate for.
         * 
         * May contain wildcards, such as ``*.domain.com``.
         */
        @Override
        public java.lang.String getDomainName() {
            return this.jsiiGet("domainName", java.lang.String.class);
        }

        /**
         * Fully-qualified domain name to request a certificate for.
         * 
         * May contain wildcards, such as ``*.domain.com``.
         */
        @Override
        public void setDomainName(final java.lang.String value) {
            this.jsiiSet("domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
        }

        /**
         * Alternative domain names on your certificate.
         * 
         * Use this to register alternative domain names that represent the same site.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.jsiiGet("subjectAlternativeNames", java.util.List.class);
        }

        /**
         * Alternative domain names on your certificate.
         * 
         * Use this to register alternative domain names that represent the same site.
         */
        @Override
        public void setSubjectAlternativeNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("subjectAlternativeNames", value);
        }

        /**
         * What validation domain to use for every requested domain.
         * 
         * Has to be a superdomain of the requested domain.
         * @default Apex domain is used for every domain that's not overridden.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this.jsiiGet("validationDomains", java.util.Map.class);
        }

        /**
         * What validation domain to use for every requested domain.
         * 
         * Has to be a superdomain of the requested domain.
         * @default Apex domain is used for every domain that's not overridden.
         */
        @Override
        public void setValidationDomains(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("validationDomains", value);
        }
    }
}
