/**
 * <h2>Amazon Certificate Manager Construct Library</h2>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge" alt="Stability: Experimental" /></p>
 * <blockquote>
 * <p><strong>This is a <em>developer preview</em> (public beta) module. Releases might lack important features and might have
 * future breaking changes.</strong></p>
 * <p>This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.</p>
 * </blockquote>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>This package provides Constructs for provisioning and referencing certificates which
 * can be used in CloudFront and ELB.</p>
 * <h3>DNS-validated certificates</h3>
 * <p>The <code>DnsValidatedCertificateRequest</code> class provides a Custom Resource by which
 * you can request a TLS certificate from AWS Certificate Manager that is
 * automatically validated using a cryptographically secure DNS record. For this to
 * work, there must be a Route 53 public zone that is responsible for serving
 * records under the Domain Name of the requested certificate. For example, if you
 * request a certificate for <code>www.example.com</code>, there must be a Route 53 public
 * zone <code>example.com</code> that provides authoritative records for the domain.</p>
 * <h4>Example</h4>
 * <pre><code class="language-ts">import { HostedZoneProvider } from '@aws-cdk/aws-route53';
 * import { DnsValidatedCertificate } from '@aws-cdk/aws-certificatemanager';
 * 
 * const hostedZone = new HostedZoneProvider(this, {
 *     domainName: 'example.com',
 *     privateZone: false
 * }).findAndImport(this, 'ExampleDotCom');
 * 
 * const certificate = new DnsValidatedCertificate(this, 'TestCertificate', {
 *     domainName: 'test.example.com',
 *     hostedZone: hostedZone
 * });
 * </code></pre>
 * <h3>Email validation</h3>
 * <p>Otherwise, if certificates are created as part of a CloudFormation run, the
 * CloudFormation provisioning will not complete until domain ownership for the
 * certificate is completed. For email validation, this involves receiving an
 * email on one of a number of predefined domains and following the instructions
 * in the email. The email addresses use will be:</p>
 * <ul>
 * <li>admin@domain.com</li>
 * <li>administrator@domain.com</li>
 * <li>hostmaster@domain.com</li>
 * <li>postmaster@domain.com</li>
 * <li>webmaster@domain.com</li>
 * </ul>
 * <p>Because of these blocks, it's probably better to provision your certificates either in a separate
 * stack from your main service, or provision them manually. In both cases, you'll import the
 * certificate into your stack afterwards.</p>
 * <h4>Example</h4>
 * <p>Provision a new certificate by creating an instance of <code>Certificate</code>. Email validation will be sent
 * to <code>example.com</code>:</p>
 * <pre><code class="language-ts">const certificate = new Certificate(this, 'Certificate', {
 *     domainName: 'test.example.com'
 * });
 * </code></pre>
 * <h3>Importing</h3>
 * <p>Import a certificate manually, if you know the ARN:</p>
 * <pre><code class="language-ts">const certificate = Certificate.import(this, 'Certificate', {
 *     certificateArn: &quot;arn:aws:...&quot;
 * });
 * </code></pre>
 * <h3>Sharing between Stacks</h3>
 * <p>To share the certificate between stacks in the same CDK application, simply
 * pass the <code>Certificate</code> object between the stacks.</p>
 * <h2>TODO</h2>
 * <ul>
 * <li>[ ] Custom Resource that can look up the certificate ARN by domain name by querying ACM.</li>
 * </ul>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.certificatemanager;
