/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.certificatemanager;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnCertificateProps
extends JsiiSerializable {
    public String getDomainName();

    public Object getDomainValidationOptions();

    public List<String> getSubjectAlternativeNames();

    public List<CfnTag> getTags();

    public String getValidationMethod();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _domainName;
        @Nullable
        private Object _domainValidationOptions;
        @Nullable
        private List<String> _subjectAlternativeNames;
        @Nullable
        private List<CfnTag> _tags;
        @Nullable
        private String _validationMethod;

        public Builder withDomainName(String value) {
            this._domainName = Objects.requireNonNull(value, "domainName is required");
            return this;
        }

        public Builder withDomainValidationOptions(@Nullable IResolvable value) {
            this._domainValidationOptions = value;
            return this;
        }

        public Builder withDomainValidationOptions(@Nullable List<Object> value) {
            this._domainValidationOptions = value;
            return this;
        }

        public Builder withSubjectAlternativeNames(@Nullable List<String> value) {
            this._subjectAlternativeNames = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public Builder withValidationMethod(@Nullable String value) {
            this._validationMethod = value;
            return this;
        }

        public CfnCertificateProps build() {
            return new CfnCertificateProps(){
                private final String $domainName;
                @Nullable
                private final Object $domainValidationOptions;
                @Nullable
                private final List<String> $subjectAlternativeNames;
                @Nullable
                private final List<CfnTag> $tags;
                @Nullable
                private final String $validationMethod;
                {
                    this.$domainName = Objects.requireNonNull(_domainName, "domainName is required");
                    this.$domainValidationOptions = _domainValidationOptions;
                    this.$subjectAlternativeNames = _subjectAlternativeNames;
                    this.$tags = _tags;
                    this.$validationMethod = _validationMethod;
                }

                @Override
                public String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public Object getDomainValidationOptions() {
                    return this.$domainValidationOptions;
                }

                @Override
                public List<String> getSubjectAlternativeNames() {
                    return this.$subjectAlternativeNames;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public String getValidationMethod() {
                    return this.$validationMethod;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("domainName", om.valueToTree((Object)this.getDomainName()));
                    if (this.getDomainValidationOptions() != null) {
                        obj.set("domainValidationOptions", om.valueToTree(this.getDomainValidationOptions()));
                    }
                    if (this.getSubjectAlternativeNames() != null) {
                        obj.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getValidationMethod() != null) {
                        obj.set("validationMethod", om.valueToTree((Object)this.getValidationMethod()));
                    }
                    return obj;
                }
            };
        }
    }
}

