package software.amazon.awscdk.services.certificatemanager;
/**
 * Properties for your certificate
 */
public interface CertificateProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Fully-qualified domain name to request a certificate for.
     * 
     * May contain wildcards, such as ``*.domain.com``.
     */
    java.lang.String getDomainName();
    /**
     * Fully-qualified domain name to request a certificate for.
     * 
     * May contain wildcards, such as ``*.domain.com``.
     */
    void setDomainName(final java.lang.String value);
    /**
     * Alternative domain names on your certificate.
     * 
     * Use this to register alternative domain names that represent the same site.
     */
    java.util.List<java.lang.String> getSubjectAlternativeNames();
    /**
     * Alternative domain names on your certificate.
     * 
     * Use this to register alternative domain names that represent the same site.
     */
    void setSubjectAlternativeNames(final java.util.List<java.lang.String> value);
    /**
     * What validation domain to use for every requested domain.
     * 
     * Has to be a superdomain of the requested domain.
     * @default Apex domain is used for every domain that's not overridden.
     */
    java.util.Map<java.lang.String, java.lang.String> getValidationDomains();
    /**
     * What validation domain to use for every requested domain.
     * 
     * Has to be a superdomain of the requested domain.
     * @default Apex domain is used for every domain that's not overridden.
     */
    void setValidationDomains(final java.util.Map<java.lang.String, java.lang.String> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link CertificateProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * Fully-qualified domain name to request a certificate for.
         * 
         * May contain wildcards, such as ``*.domain.com``.
         */
        public Build withDomainName(final java.lang.String value) {
            return new FullBuilder().withDomainName(value);
        }

        public interface Build {
            /**
             * @return a new {@link CertificateProps} object, initialized with the values set on this builder.
             */
            CertificateProps build();
            /**
             * Alternative domain names on your certificate.
             * 
             * Use this to register alternative domain names that represent the same site.
             */
            Build withSubjectAlternativeNames(final java.util.List<java.lang.String> value);
            /**
             * What validation domain to use for every requested domain.
             * 
             * Has to be a superdomain of the requested domain.
             * @default Apex domain is used for every domain that's not overridden.
             */
            Build withValidationDomains(final java.util.Map<java.lang.String, java.lang.String> value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * Fully-qualified domain name to request a certificate for.
             * 
             * May contain wildcards, such as ``*.domain.com``.
             */
            public Build withDomainName(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "CertificateProps#domainName is required");
                this.instance._domainName = value;
                return this;
            }
            /**
             * Alternative domain names on your certificate.
             * 
             * Use this to register alternative domain names that represent the same site.
             */
            public Build withSubjectAlternativeNames(final java.util.List<java.lang.String> value) {
                this.instance._subjectAlternativeNames = value;
                return this;
            }
            /**
             * What validation domain to use for every requested domain.
             * 
             * Has to be a superdomain of the requested domain.
             * @default Apex domain is used for every domain that's not overridden.
             */
            public Build withValidationDomains(final java.util.Map<java.lang.String, java.lang.String> value) {
                this.instance._validationDomains = value;
                return this;
            }
            public CertificateProps build() {
                CertificateProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link CertificateProps}.
     */
    final class Jsii$Pojo implements CertificateProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _domainName;

        public java.lang.String getDomainName() {
            return this._domainName;
        }
        public void setDomainName(final java.lang.String value) {
            this._domainName = value;
        }

        protected java.util.List<java.lang.String> _subjectAlternativeNames;

        public java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this._subjectAlternativeNames;
        }
        public void setSubjectAlternativeNames(final java.util.List<java.lang.String> value) {
            this._subjectAlternativeNames = value;
        }

        protected java.util.Map<java.lang.String, java.lang.String> _validationDomains;

        public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this._validationDomains;
        }
        public void setValidationDomains(final java.util.Map<java.lang.String, java.lang.String> value) {
            this._validationDomains = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.certificatemanager.CertificateProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * Fully-qualified domain name to request a certificate for.
         * 
         * May contain wildcards, such as ``*.domain.com``.
         */
        public java.lang.String getDomainName() {
            return this.jsiiGet("domainName", java.lang.String.class);
        }
        /**
         * Fully-qualified domain name to request a certificate for.
         * 
         * May contain wildcards, such as ``*.domain.com``.
         */
        public void setDomainName(final java.lang.String value) {
            this.jsiiSet("domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
        }
        /**
         * Alternative domain names on your certificate.
         * 
         * Use this to register alternative domain names that represent the same site.
         */
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.jsiiGet("subjectAlternativeNames", java.util.List.class);
        }
        /**
         * Alternative domain names on your certificate.
         * 
         * Use this to register alternative domain names that represent the same site.
         */
        public void setSubjectAlternativeNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("subjectAlternativeNames", value);
        }
        /**
         * What validation domain to use for every requested domain.
         * 
         * Has to be a superdomain of the requested domain.
         * @default Apex domain is used for every domain that's not overridden.
         */
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this.jsiiGet("validationDomains", java.util.Map.class);
        }
        /**
         * What validation domain to use for every requested domain.
         * 
         * Has to be a superdomain of the requested domain.
         * @default Apex domain is used for every domain that's not overridden.
         */
        public void setValidationDomains(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("validationDomains", value);
        }
    }
}
