package software.amazon.awscdk.services.certificatemanager;
/**
 * Reference to an existing Certificate
 */
public interface CertificateRefProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The certificate's ARN
     */
    software.amazon.awscdk.services.certificatemanager.CertificateArn getCertificateArn();
    /**
     * The certificate's ARN
     */
    void setCertificateArn(final software.amazon.awscdk.services.certificatemanager.CertificateArn value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link CertificateRefProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The certificate's ARN
         */
        public Build withCertificateArn(final software.amazon.awscdk.services.certificatemanager.CertificateArn value) {
            return new FullBuilder().withCertificateArn(value);
        }

        public interface Build {
            /**
             * @return a new {@link CertificateRefProps} object, initialized with the values set on this builder.
             */
            CertificateRefProps build();
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The certificate's ARN
             */
            public Build withCertificateArn(final software.amazon.awscdk.services.certificatemanager.CertificateArn value) {
                java.util.Objects.requireNonNull(value, "CertificateRefProps#certificateArn is required");
                this.instance._certificateArn = value;
                return this;
            }
            public CertificateRefProps build() {
                CertificateRefProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link CertificateRefProps}.
     */
    final class Jsii$Pojo implements CertificateRefProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.certificatemanager.CertificateArn _certificateArn;

        public software.amazon.awscdk.services.certificatemanager.CertificateArn getCertificateArn() {
            return this._certificateArn;
        }
        public void setCertificateArn(final software.amazon.awscdk.services.certificatemanager.CertificateArn value) {
            this._certificateArn = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.certificatemanager.CertificateRefProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The certificate's ARN
         */
        public software.amazon.awscdk.services.certificatemanager.CertificateArn getCertificateArn() {
            return this.jsiiGet("certificateArn", software.amazon.awscdk.services.certificatemanager.CertificateArn.class);
        }
        /**
         * The certificate's ARN
         */
        public void setCertificateArn(final software.amazon.awscdk.services.certificatemanager.CertificateArn value) {
            this.jsiiSet("certificateArn", java.util.Objects.requireNonNull(value, "certificateArn is required"));
        }
    }
}
