package software.amazon.awscdk.services.certificatemanager.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.cloudformation.CertificateResource")
public class CertificateResource extends software.amazon.awscdk.Resource {
    protected CertificateResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.certificatemanager.cloudformation.CertificateResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::CertificateManager::Certificate``.
     * @param parent the ``cdk.Construct`` this ``CertificateResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``CertificateResource``
     */
    public CertificateResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.certificatemanager.cloudformation.CertificateResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html
     */
    public static interface DomainValidationOptionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CertificateResource.DomainValidationOptionProperty.DomainName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
         */
        java.lang.Object getDomainName();
        /**
         * ``CertificateResource.DomainValidationOptionProperty.DomainName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
         */
        void setDomainName(final java.lang.String value);
        /**
         * ``CertificateResource.DomainValidationOptionProperty.DomainName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
         */
        void setDomainName(final software.amazon.awscdk.Token value);
        /**
         * ``CertificateResource.DomainValidationOptionProperty.ValidationDomain``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
         */
        java.lang.Object getValidationDomain();
        /**
         * ``CertificateResource.DomainValidationOptionProperty.ValidationDomain``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
         */
        void setValidationDomain(final java.lang.String value);
        /**
         * ``CertificateResource.DomainValidationOptionProperty.ValidationDomain``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
         */
        void setValidationDomain(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link DomainValidationOptionProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``CertificateResource.DomainValidationOptionProperty.DomainName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
             */
            public ValidationDomainStep withDomainName(final java.lang.String value) {
                return new FullBuilder().withDomainName(value);
            }
            /**
             * ``CertificateResource.DomainValidationOptionProperty.DomainName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
             */
            public ValidationDomainStep withDomainName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withDomainName(value);
            }

            public interface ValidationDomainStep {
                /**
                 * ``CertificateResource.DomainValidationOptionProperty.ValidationDomain``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
                 */
                Build withValidationDomain(final java.lang.String value);
                /**
                 * ``CertificateResource.DomainValidationOptionProperty.ValidationDomain``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
                 */
                Build withValidationDomain(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link DomainValidationOptionProperty} object, initialized with the values set on this builder.
                 */
                DomainValidationOptionProperty build();
            }

            final class FullBuilder implements ValidationDomainStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``CertificateResource.DomainValidationOptionProperty.DomainName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
                 */
                public ValidationDomainStep withDomainName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "DomainValidationOptionProperty#domainName is required");
                    this.instance._domainName = value;
                    return this;
                }
                /**
                 * ``CertificateResource.DomainValidationOptionProperty.DomainName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
                 */
                public ValidationDomainStep withDomainName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "DomainValidationOptionProperty#domainName is required");
                    this.instance._domainName = value;
                    return this;
                }
                /**
                 * ``CertificateResource.DomainValidationOptionProperty.ValidationDomain``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
                 */
                public Build withValidationDomain(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "DomainValidationOptionProperty#validationDomain is required");
                    this.instance._validationDomain = value;
                    return this;
                }
                /**
                 * ``CertificateResource.DomainValidationOptionProperty.ValidationDomain``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
                 */
                public Build withValidationDomain(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "DomainValidationOptionProperty#validationDomain is required");
                    this.instance._validationDomain = value;
                    return this;
                }
                public DomainValidationOptionProperty build() {
                    DomainValidationOptionProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link DomainValidationOptionProperty}.
         */
        final class Jsii$Pojo implements DomainValidationOptionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _domainName;

            public java.lang.Object getDomainName() {
                return this._domainName;
            }
            public void setDomainName(final java.lang.String value) {
                this._domainName = value;
            }
            public void setDomainName(final software.amazon.awscdk.Token value) {
                this._domainName = value;
            }

            protected java.lang.Object _validationDomain;

            public java.lang.Object getValidationDomain() {
                return this._validationDomain;
            }
            public void setValidationDomain(final java.lang.String value) {
                this._validationDomain = value;
            }
            public void setValidationDomain(final software.amazon.awscdk.Token value) {
                this._validationDomain = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.certificatemanager.cloudformation.CertificateResource.DomainValidationOptionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``CertificateResource.DomainValidationOptionProperty.DomainName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
             */
            public java.lang.Object getDomainName() {
                return this.jsiiGet("domainName", java.lang.Object.class);
            }
            /**
             * ``CertificateResource.DomainValidationOptionProperty.DomainName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
             */
            public void setDomainName(final java.lang.String value) {
                this.jsiiSet("domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
            }
            /**
             * ``CertificateResource.DomainValidationOptionProperty.DomainName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
             */
            public void setDomainName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
            }
            /**
             * ``CertificateResource.DomainValidationOptionProperty.ValidationDomain``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
             */
            public java.lang.Object getValidationDomain() {
                return this.jsiiGet("validationDomain", java.lang.Object.class);
            }
            /**
             * ``CertificateResource.DomainValidationOptionProperty.ValidationDomain``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
             */
            public void setValidationDomain(final java.lang.String value) {
                this.jsiiSet("validationDomain", java.util.Objects.requireNonNull(value, "validationDomain is required"));
            }
            /**
             * ``CertificateResource.DomainValidationOptionProperty.ValidationDomain``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
             */
            public void setValidationDomain(final software.amazon.awscdk.Token value) {
                this.jsiiSet("validationDomain", java.util.Objects.requireNonNull(value, "validationDomain is required"));
            }
        }
    }
}
