package software.amazon.awscdk.services.certificatemanager;

/**
 * Properties for your certificate.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:10:52.338Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CertificateProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Fully-qualified domain name to request a certificate for.
     * 
     * May contain wildcards, such as ``*.domain.com``.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDomainName();
    /**
     * Alternative domain names on your certificate.
     * 
     * Use this to register alternative domain names that represent the same site.
     * 
     * Default: - No additional FQDNs will be included as alternative domain names.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getSubjectAlternativeNames();
    /**
     * What validation domain to use for every requested domain.
     * 
     * Has to be a superdomain of the requested domain.
     * 
     * Default: - Apex domain is used for every domain that's not overridden.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.String> getValidationDomains();
    /**
     * Validation method used to assert domain ownership.
     * 
     * Default: ValidationMethod.EMAIL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.certificatemanager.ValidationMethod getValidationMethod();

    /**
     * @return a {@link Builder} of {@link CertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _domainName;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _subjectAlternativeNames;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _validationDomains;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.certificatemanager.ValidationMethod _validationMethod;

        /**
         * Sets the value of DomainName
         * @param value Fully-qualified domain name to request a certificate for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDomainName(final java.lang.String value) {
            this._domainName = java.util.Objects.requireNonNull(value, "domainName is required");
            return this;
        }
        /**
         * Sets the value of SubjectAlternativeNames
         * @param value Alternative domain names on your certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSubjectAlternativeNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._subjectAlternativeNames = value;
            return this;
        }
        /**
         * Sets the value of ValidationDomains
         * @param value What validation domain to use for every requested domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withValidationDomains(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._validationDomains = value;
            return this;
        }
        /**
         * Sets the value of ValidationMethod
         * @param value Validation method used to assert domain ownership.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withValidationMethod(@javax.annotation.Nullable final software.amazon.awscdk.services.certificatemanager.ValidationMethod value) {
            this._validationMethod = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CertificateProps build() {
            return new CertificateProps() {
                private final java.lang.String $domainName = java.util.Objects.requireNonNull(_domainName, "domainName is required");
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $subjectAlternativeNames = _subjectAlternativeNames;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $validationDomains = _validationDomains;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.certificatemanager.ValidationMethod $validationMethod = _validationMethod;

                @Override
                public java.lang.String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public java.util.List<java.lang.String> getSubjectAlternativeNames() {
                    return this.$subjectAlternativeNames;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
                    return this.$validationDomains;
                }

                @Override
                public software.amazon.awscdk.services.certificatemanager.ValidationMethod getValidationMethod() {
                    return this.$validationMethod;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("domainName", om.valueToTree(this.getDomainName()));
                    if (this.getSubjectAlternativeNames() != null) {
                        obj.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
                    }
                    if (this.getValidationDomains() != null) {
                        obj.set("validationDomains", om.valueToTree(this.getValidationDomains()));
                    }
                    if (this.getValidationMethod() != null) {
                        obj.set("validationMethod", om.valueToTree(this.getValidationMethod()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.certificatemanager.CertificateProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Fully-qualified domain name to request a certificate for.
         * 
         * May contain wildcards, such as ``*.domain.com``.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getDomainName() {
            return this.jsiiGet("domainName", java.lang.String.class);
        }

        /**
         * Alternative domain names on your certificate.
         * 
         * Use this to register alternative domain names that represent the same site.
         * 
         * Default: - No additional FQDNs will be included as alternative domain names.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.jsiiGet("subjectAlternativeNames", java.util.List.class);
        }

        /**
         * What validation domain to use for every requested domain.
         * 
         * Has to be a superdomain of the requested domain.
         * 
         * Default: - Apex domain is used for every domain that's not overridden.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this.jsiiGet("validationDomains", java.util.Map.class);
        }

        /**
         * Validation method used to assert domain ownership.
         * 
         * Default: ValidationMethod.EMAIL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.certificatemanager.ValidationMethod getValidationMethod() {
            return this.jsiiGet("validationMethod", software.amazon.awscdk.services.certificatemanager.ValidationMethod.class);
        }
    }
}
