/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.certificatemanager;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.certificatemanager.ValidationMethod;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CertificateProps
extends JsiiSerializable {
    public String getDomainName();

    public List<String> getSubjectAlternativeNames();

    public Map<String, String> getValidationDomains();

    public ValidationMethod getValidationMethod();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _domainName;
        @Nullable
        private List<String> _subjectAlternativeNames;
        @Nullable
        private Map<String, String> _validationDomains;
        @Nullable
        private ValidationMethod _validationMethod;

        public Builder withDomainName(String value) {
            this._domainName = Objects.requireNonNull(value, "domainName is required");
            return this;
        }

        public Builder withSubjectAlternativeNames(@Nullable List<String> value) {
            this._subjectAlternativeNames = value;
            return this;
        }

        public Builder withValidationDomains(@Nullable Map<String, String> value) {
            this._validationDomains = value;
            return this;
        }

        public Builder withValidationMethod(@Nullable ValidationMethod value) {
            this._validationMethod = value;
            return this;
        }

        public CertificateProps build() {
            return new CertificateProps(){
                private final String $domainName;
                @Nullable
                private final List<String> $subjectAlternativeNames;
                @Nullable
                private final Map<String, String> $validationDomains;
                @Nullable
                private final ValidationMethod $validationMethod;
                {
                    this.$domainName = Objects.requireNonNull(_domainName, "domainName is required");
                    this.$subjectAlternativeNames = _subjectAlternativeNames;
                    this.$validationDomains = _validationDomains;
                    this.$validationMethod = _validationMethod;
                }

                @Override
                public String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public List<String> getSubjectAlternativeNames() {
                    return this.$subjectAlternativeNames;
                }

                @Override
                public Map<String, String> getValidationDomains() {
                    return this.$validationDomains;
                }

                @Override
                public ValidationMethod getValidationMethod() {
                    return this.$validationMethod;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("domainName", om.valueToTree((Object)this.getDomainName()));
                    if (this.getSubjectAlternativeNames() != null) {
                        obj.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
                    }
                    if (this.getValidationDomains() != null) {
                        obj.set("validationDomains", om.valueToTree(this.getValidationDomains()));
                    }
                    if (this.getValidationMethod() != null) {
                        obj.set("validationMethod", om.valueToTree((Object)this.getValidationMethod()));
                    }
                    return obj;
                }
            };
        }
    }
}

