package software.amazon.awscdk.services.certificatemanager;

/**
 * A CloudFormation `AWS::CertificateManager::Certificate`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-30T08:37:30.713Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.CfnCertificate")
public class CfnCertificate extends software.amazon.awscdk.core.CfnResource {

    protected CfnCertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.certificatemanager.CfnCertificate.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::CertificateManager::Certificate`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnCertificate(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.certificatemanager.CfnCertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::CertificateManager::Certificate.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::CertificateManager::Certificate.DomainName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDomainName() {
        return this.jsiiGet("domainName", java.lang.String.class);
    }

    /**
     * `AWS::CertificateManager::Certificate.DomainName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDomainName(final java.lang.String value) {
        this.jsiiSet("domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
    }

    /**
     * `AWS::CertificateManager::Certificate.DomainValidationOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainvalidationoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getDomainValidationOptions() {
        return this.jsiiGet("domainValidationOptions", java.lang.Object.class);
    }

    /**
     * `AWS::CertificateManager::Certificate.DomainValidationOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainvalidationoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDomainValidationOptions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("domainValidationOptions", value);
    }

    /**
     * `AWS::CertificateManager::Certificate.DomainValidationOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainvalidationoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDomainValidationOptions(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("domainValidationOptions", value);
    }

    /**
     * `AWS::CertificateManager::Certificate.SubjectAlternativeNames`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-subjectalternativenames
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getSubjectAlternativeNames() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("subjectAlternativeNames", java.util.List.class));
    }

    /**
     * `AWS::CertificateManager::Certificate.SubjectAlternativeNames`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-subjectalternativenames
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSubjectAlternativeNames(final java.util.List<java.lang.String> value) {
        this.jsiiSet("subjectAlternativeNames", value);
    }

    /**
     * `AWS::CertificateManager::Certificate.ValidationMethod`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-validationmethod
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getValidationMethod() {
        return this.jsiiGet("validationMethod", java.lang.String.class);
    }

    /**
     * `AWS::CertificateManager::Certificate.ValidationMethod`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-validationmethod
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setValidationMethod(final java.lang.String value) {
        this.jsiiSet("validationMethod", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DomainValidationOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCertificate.DomainValidationOptionProperty.DomainName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDomainName();

        /**
         * `CfnCertificate.DomainValidationOptionProperty.ValidationDomain`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getValidationDomain();

        /**
         * @return a {@link Builder} of {@link DomainValidationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainValidationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String domainName;
            private java.lang.String validationDomain;

            /**
             * Sets the value of DomainName
             * @param domainName `CfnCertificate.DomainValidationOptionProperty.DomainName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of ValidationDomain
             * @param validationDomain `CfnCertificate.DomainValidationOptionProperty.ValidationDomain`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder validationDomain(java.lang.String validationDomain) {
                this.validationDomain = validationDomain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainValidationOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DomainValidationOptionProperty build() {
                return new Jsii$Proxy(domainName, validationDomain);
            }
        }

        /**
         * An implementation for {@link DomainValidationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainValidationOptionProperty {
            private final java.lang.String domainName;
            private final java.lang.String validationDomain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.domainName = this.jsiiGet("domainName", java.lang.String.class);
                this.validationDomain = this.jsiiGet("validationDomain", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String domainName, java.lang.String validationDomain) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
                this.validationDomain = java.util.Objects.requireNonNull(validationDomain, "validationDomain is required");
            }

            @Override
            public java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public java.lang.String getValidationDomain() {
                return this.validationDomain;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("domainName", om.valueToTree(this.getDomainName()));
                obj.set("validationDomain", om.valueToTree(this.getValidationDomain()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainValidationOptionProperty.Jsii$Proxy that = (DomainValidationOptionProperty.Jsii$Proxy) o;

                if (!domainName.equals(that.domainName)) return false;
                return this.validationDomain.equals(that.validationDomain);
            }

            @Override
            public int hashCode() {
                int result = this.domainName.hashCode();
                result = 31 * result + (this.validationDomain.hashCode());
                return result;
            }
        }
    }
}
