package software.amazon.awscdk.services.certificatemanager;

/**
 * Properties for your certificate.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-08T20:44:24.144Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.CertificateProps")
@software.amazon.jsii.Jsii.Proxy(CertificateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CertificateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Fully-qualified domain name to request a certificate for.
     * <p>
     * May contain wildcards, such as <code>*.domain.com</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * Alternative domain names on your certificate.
     * <p>
     * Use this to register alternative domain names that represent the same site.
     * <p>
     * Default: - No additional FQDNs will be included as alternative domain names.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubjectAlternativeNames() {
        return null;
    }

    /**
     * How to validate this certificate.
     * <p>
     * Default: CertificateValidation.fromEmail()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.CertificateValidation getValidation() {
        return null;
    }

    /**
     * (deprecated) What validation domain to use for every requested domain.
     * <p>
     * Has to be a superdomain of the requested domain.
     * <p>
     * Default: - Apex domain is used for every domain that's not overridden.
     * <p>
     * @deprecated use `validation` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
        return null;
    }

    /**
     * (deprecated) Validation method used to assert domain ownership.
     * <p>
     * Default: ValidationMethod.EMAIL
     * <p>
     * @deprecated use `validation` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.ValidationMethod getValidationMethod() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CertificateProps> {
        private java.lang.String domainName;
        private java.util.List<java.lang.String> subjectAlternativeNames;
        private software.amazon.awscdk.services.certificatemanager.CertificateValidation validation;
        private java.util.Map<java.lang.String, java.lang.String> validationDomains;
        private software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod;

        /**
         * Sets the value of {@link CertificateProps#getDomainName}
         * @param domainName Fully-qualified domain name to request a certificate for. This parameter is required.
         *                   May contain wildcards, such as <code>*.domain.com</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CertificateProps#getSubjectAlternativeNames}
         * @param subjectAlternativeNames Alternative domain names on your certificate.
         *                                Use this to register alternative domain names that represent the same site.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(java.util.List<java.lang.String> subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        /**
         * Sets the value of {@link CertificateProps#getValidation}
         * @param validation How to validate this certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validation(software.amazon.awscdk.services.certificatemanager.CertificateValidation validation) {
            this.validation = validation;
            return this;
        }

        /**
         * Sets the value of {@link CertificateProps#getValidationDomains}
         * @param validationDomains What validation domain to use for every requested domain.
         *                          Has to be a superdomain of the requested domain.
         * @return {@code this}
         * @deprecated use `validation` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder validationDomains(java.util.Map<java.lang.String, java.lang.String> validationDomains) {
            this.validationDomains = validationDomains;
            return this;
        }

        /**
         * Sets the value of {@link CertificateProps#getValidationMethod}
         * @param validationMethod Validation method used to assert domain ownership.
         * @return {@code this}
         * @deprecated use `validation` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder validationMethod(software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            this.validationMethod = validationMethod;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CertificateProps build() {
            return new Jsii$Proxy(domainName, subjectAlternativeNames, validation, validationDomains, validationMethod);
        }
    }

    /**
     * An implementation for {@link CertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateProps {
        private final java.lang.String domainName;
        private final java.util.List<java.lang.String> subjectAlternativeNames;
        private final software.amazon.awscdk.services.certificatemanager.CertificateValidation validation;
        private final java.util.Map<java.lang.String, java.lang.String> validationDomains;
        private final software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subjectAlternativeNames = software.amazon.jsii.Kernel.get(this, "subjectAlternativeNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.validation = software.amazon.jsii.Kernel.get(this, "validation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class));
            this.validationDomains = software.amazon.jsii.Kernel.get(this, "validationDomains", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.validationMethod = software.amazon.jsii.Kernel.get(this, "validationMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ValidationMethod.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String domainName, final java.util.List<java.lang.String> subjectAlternativeNames, final software.amazon.awscdk.services.certificatemanager.CertificateValidation validation, final java.util.Map<java.lang.String, java.lang.String> validationDomains, final software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
            this.subjectAlternativeNames = subjectAlternativeNames;
            this.validation = validation;
            this.validationDomains = validationDomains;
            this.validationMethod = validationMethod;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.CertificateValidation getValidation() {
            return this.validation;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this.validationDomains;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.ValidationMethod getValidationMethod() {
            return this.validationMethod;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getSubjectAlternativeNames() != null) {
                data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
            }
            if (this.getValidation() != null) {
                data.set("validation", om.valueToTree(this.getValidation()));
            }
            if (this.getValidationDomains() != null) {
                data.set("validationDomains", om.valueToTree(this.getValidationDomains()));
            }
            if (this.getValidationMethod() != null) {
                data.set("validationMethod", om.valueToTree(this.getValidationMethod()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-certificatemanager.CertificateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CertificateProps.Jsii$Proxy that = (CertificateProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (this.subjectAlternativeNames != null ? !this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames != null) return false;
            if (this.validation != null ? !this.validation.equals(that.validation) : that.validation != null) return false;
            if (this.validationDomains != null ? !this.validationDomains.equals(that.validationDomains) : that.validationDomains != null) return false;
            return this.validationMethod != null ? this.validationMethod.equals(that.validationMethod) : that.validationMethod == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
            result = 31 * result + (this.validation != null ? this.validation.hashCode() : 0);
            result = 31 * result + (this.validationDomains != null ? this.validationDomains.hashCode() : 0);
            result = 31 * result + (this.validationMethod != null ? this.validationMethod.hashCode() : 0);
            return result;
        }
    }
}
