package software.amazon.awscdk.services.certificatemanager;

/**
 * A certificate managed by AWS Certificate Manager.
 * 
 * Will be automatically
 * validated using DNS validation against the specified Route 53 hosted zone.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.4 (build 96d89e1)", date = "2019-11-12T11:54:57.470Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.DnsValidatedCertificate")
public class DnsValidatedCertificate extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.certificatemanager.ICertificate {

    protected DnsValidatedCertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DnsValidatedCertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DnsValidatedCertificate(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Validate the current construct.
     * 
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", java.util.List.class));
    }

    /**
     * The certificate's ARN.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getCertificateArn() {
        return this.jsiiGet("certificateArn", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * 
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps.Builder();
        }

        /**
         * @return {@code this}
         * @param domainName Fully-qualified domain name to request a certificate for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * @return {@code this}
         * @param subjectAlternativeNames Alternative domain names on your certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(final java.util.List<java.lang.String> subjectAlternativeNames) {
            this.props.subjectAlternativeNames(subjectAlternativeNames);
            return this;
        }

        /**
         * @return {@code this}
         * @param validationDomains What validation domain to use for every requested domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationDomains(final java.util.Map<java.lang.String, java.lang.String> validationDomains) {
            this.props.validationDomains(validationDomains);
            return this;
        }

        /**
         * @return {@code this}
         * @param validationMethod Validation method used to assert domain ownership. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationMethod(final software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            this.props.validationMethod(validationMethod);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param hostedZone Route 53 Hosted Zone used to perform DNS validation of the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hostedZone(final software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.props.hostedZone(hostedZone);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param customResourceRole Role to use for the custom resource that creates the validated certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customResourceRole(final software.amazon.awscdk.services.iam.IRole customResourceRole) {
            this.props.customResourceRole(customResourceRole);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param region AWS region that will host the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate build() {
            return new software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
