package software.amazon.awscdk.services.certificatemanager;

/**
 * A CloudFormation `AWS::CertificateManager::Certificate`.
 * <p>
 * The <code>AWS::CertificateManager::Certificate</code> resource requests an AWS Certificate Manager ( ACM ) certificate that you can use to enable secure connections. For example, you can deploy an ACM certificate to an Elastic Load Balancer to enable HTTPS support. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_RequestCertificate.html">RequestCertificate</a> in the AWS Certificate Manager API Reference.
 * <p>
 * <blockquote>
 * <p>
 * When you use the <code>AWS::CertificateManager::Certificate</code> resource in a CloudFormation stack, domain validation is handled automatically if all three of the following are true: The certificate domain is hosted in Amazon Route 53, the domain resides in your AWS account , and you are using DNS validation.
 * <p>
 * However, if the certificate uses email validation, or if the domain is not hosted in Route 53, then the stack will remain in the <code>CREATE_IN_PROGRESS</code> state. Further stack operations are delayed until you validate the certificate request, either by acting upon the instructions in the validation email, or by adding a CNAME record to your DNS configuration. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/dns-validation.html">Option 1: DNS Validation</a> and <a href="https://docs.aws.amazon.com/acm/latest/userguide/email-validation.html">Option 2: Email Validation</a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.certificatemanager.*;
 * CfnCertificate cfnCertificate = CfnCertificate.Builder.create(this, "MyCfnCertificate")
 *         .domainName("domainName")
 *         // the properties below are optional
 *         .certificateAuthorityArn("certificateAuthorityArn")
 *         .certificateTransparencyLoggingPreference("certificateTransparencyLoggingPreference")
 *         .domainValidationOptions(List.of(DomainValidationOptionProperty.builder()
 *                 .domainName("domainName")
 *                 // the properties below are optional
 *                 .hostedZoneId("hostedZoneId")
 *                 .validationDomain("validationDomain")
 *                 .build()))
 *         .subjectAlternativeNames(List.of("subjectAlternativeNames"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .validationMethod("validationMethod")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-13T22:11:57.034Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.CfnCertificate")
public class CfnCertificate extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.certificatemanager.CfnCertificate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CertificateManager::Certificate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCertificate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.CfnCertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Key-value pairs that can identify the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The fully qualified domain name (FQDN), such as www.example.com, with which you want to secure an ACM certificate. Use an asterisk (*) to create a wildcard certificate that protects several sites in the same domain. For example, `*.example.com` protects `www.example.com` , `site.example.com` , and `images.example.com.`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The fully qualified domain name (FQDN), such as www.example.com, with which you want to secure an ACM certificate. Use an asterisk (*) to create a wildcard certificate that protects several sites in the same domain. For example, `*.example.com` protects `www.example.com` , `site.example.com` , and `images.example.com.`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the private certificate authority (CA) that will be used to issue the certificate.
     * <p>
     * If you do not provide an ARN and you are trying to request a private certificate, ACM will attempt to issue a public certificate. For more information about private CAs, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaWelcome.html">AWS Certificate Manager Private Certificate Authority (PCA)</a> user guide. The ARN must have the following form:
     * <p>
     * <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCertificateAuthorityArn() {
        return software.amazon.jsii.Kernel.get(this, "certificateAuthorityArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the private certificate authority (CA) that will be used to issue the certificate.
     * <p>
     * If you do not provide an ARN and you are trying to request a private certificate, ACM will attempt to issue a public certificate. For more information about private CAs, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaWelcome.html">AWS Certificate Manager Private Certificate Authority (PCA)</a> user guide. The ARN must have the following form:
     * <p>
     * <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateAuthorityArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificateAuthorityArn", value);
    }

    /**
     * You can opt out of certificate transparency logging by specifying the `DISABLED` option. Opt in by specifying `ENABLED` .
     * <p>
     * If you do not specify a certificate transparency logging preference on a new CloudFormation template, or if you remove the logging preference from an existing template, this is the same as explicitly enabling the preference.
     * <p>
     * Changing the certificate transparency logging preference will update the existing resource by calling <code>UpdateCertificateOptions</code> on the certificate. This action will not create a new resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCertificateTransparencyLoggingPreference() {
        return software.amazon.jsii.Kernel.get(this, "certificateTransparencyLoggingPreference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * You can opt out of certificate transparency logging by specifying the `DISABLED` option. Opt in by specifying `ENABLED` .
     * <p>
     * If you do not specify a certificate transparency logging preference on a new CloudFormation template, or if you remove the logging preference from an existing template, this is the same as explicitly enabling the preference.
     * <p>
     * Changing the certificate transparency logging preference will update the existing resource by calling <code>UpdateCertificateOptions</code> on the certificate. This action will not create a new resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateTransparencyLoggingPreference(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificateTransparencyLoggingPreference", value);
    }

    /**
     * Domain information that domain name registrars use to verify your identity.
     * <p>
     * <blockquote>
     * <p>
     * In order for a AWS::CertificateManager::Certificate to be provisioned and validated in CloudFormation automatically, the <code>DomainName</code> property needs to be identical to one of the <code>DomainName</code> property supplied in DomainValidationOptions, if the ValidationMethod is <strong>DNS</strong>. Failing to keep them like-for-like will result in failure to create the domain validation records in Route53.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDomainValidationOptions() {
        return software.amazon.jsii.Kernel.get(this, "domainValidationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Domain information that domain name registrars use to verify your identity.
     * <p>
     * <blockquote>
     * <p>
     * In order for a AWS::CertificateManager::Certificate to be provisioned and validated in CloudFormation automatically, the <code>DomainName</code> property needs to be identical to one of the <code>DomainName</code> property supplied in DomainValidationOptions, if the ValidationMethod is <strong>DNS</strong>. Failing to keep them like-for-like will result in failure to create the domain validation records in Route53.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainValidationOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "domainValidationOptions", value);
    }

    /**
     * Domain information that domain name registrars use to verify your identity.
     * <p>
     * <blockquote>
     * <p>
     * In order for a AWS::CertificateManager::Certificate to be provisioned and validated in CloudFormation automatically, the <code>DomainName</code> property needs to be identical to one of the <code>DomainName</code> property supplied in DomainValidationOptions, if the ValidationMethod is <strong>DNS</strong>. Failing to keep them like-for-like will result in failure to create the domain validation records in Route53.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainValidationOptions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "domainValidationOptions", value);
    }

    /**
     * Additional FQDNs to be included in the Subject Alternative Name extension of the ACM certificate.
     * <p>
     * For example, you can add www.example.net to a certificate for which the <code>DomainName</code> field is www.example.com if users can reach your site by using either name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubjectAlternativeNames() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "subjectAlternativeNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Additional FQDNs to be included in the Subject Alternative Name extension of the ACM certificate.
     * <p>
     * For example, you can add www.example.net to a certificate for which the <code>DomainName</code> field is www.example.com if users can reach your site by using either name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubjectAlternativeNames(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subjectAlternativeNames", value);
    }

    /**
     * The method you want to use to validate that you own or control the domain associated with a public certificate.
     * <p>
     * You can <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">validate with DNS</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">validate with email</a> . We recommend that you use DNS validation.
     * <p>
     * If not specified, this property defaults to email validation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getValidationMethod() {
        return software.amazon.jsii.Kernel.get(this, "validationMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The method you want to use to validate that you own or control the domain associated with a public certificate.
     * <p>
     * You can <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">validate with DNS</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">validate with email</a> . We recommend that you use DNS validation.
     * <p>
     * If not specified, this property defaults to email validation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidationMethod(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "validationMethod", value);
    }
    /**
     * `DomainValidationOption` is a property of the [AWS::CertificateManager::Certificate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html) resource that specifies the AWS Certificate Manager ( ACM ) certificate domain to validate. Depending on the chosen validation method, ACM checks the domain's DNS record for a validation CNAME, or it attempts to send a validation email message to the domain owner.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.certificatemanager.*;
     * DomainValidationOptionProperty domainValidationOptionProperty = DomainValidationOptionProperty.builder()
     *         .domainName("domainName")
     *         // the properties below are optional
     *         .hostedZoneId("hostedZoneId")
     *         .validationDomain("validationDomain")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.CfnCertificate.DomainValidationOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(DomainValidationOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DomainValidationOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A fully qualified domain name (FQDN) in the certificate request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

        /**
         * The `HostedZoneId` option, which is available if you are using Route 53 as your domain registrar, causes ACM to add your CNAME to the domain record.
         * <p>
         * Your list of <code>DomainValidationOptions</code> must contain one and only one of the domain-validation options, and the <code>HostedZoneId</code> can be used only when <code>DNS</code> is specified as your validation method.
         * <p>
         * Use the Route 53 <code>ListHostedZones</code> API to discover IDs for available hosted zones.
         * <p>
         * This option is required for publicly trusted certificates.
         * <p>
         * <blockquote>
         * <p>
         * The <code>ListHostedZones</code> API returns IDs in the format "/hostedzone/Z111111QQQQQQQ", but CloudFormation requires the IDs to be in the format "Z111111QQQQQQQ".
         * <p>
         * </blockquote>
         * <p>
         * When you change your <code>DomainValidationOptions</code> , a new resource is created.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneId() {
            return null;
        }

        /**
         * The domain name to which you want ACM to send validation emails.
         * <p>
         * This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the <code>DomainName</code> value or a superdomain of the <code>DomainName</code> value. For example, if you request a certificate for <code>testing.example.com</code> , you can specify <code>example.com</code> as this value. In that case, ACM sends domain validation emails to the following five addresses:
         * <p>
         * <ul>
         * <li>admin&#64;example.com</li>
         * <li>administrator&#64;example.com</li>
         * <li>hostmaster&#64;example.com</li>
         * <li>postmaster&#64;example.com</li>
         * <li>webmaster&#64;example.com</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValidationDomain() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DomainValidationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainValidationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DomainValidationOptionProperty> {
            java.lang.String domainName;
            java.lang.String hostedZoneId;
            java.lang.String validationDomain;

            /**
             * Sets the value of {@link DomainValidationOptionProperty#getDomainName}
             * @param domainName A fully qualified domain name (FQDN) in the certificate request. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link DomainValidationOptionProperty#getHostedZoneId}
             * @param hostedZoneId The `HostedZoneId` option, which is available if you are using Route 53 as your domain registrar, causes ACM to add your CNAME to the domain record.
             *                     Your list of <code>DomainValidationOptions</code> must contain one and only one of the domain-validation options, and the <code>HostedZoneId</code> can be used only when <code>DNS</code> is specified as your validation method.
             *                     <p>
             *                     Use the Route 53 <code>ListHostedZones</code> API to discover IDs for available hosted zones.
             *                     <p>
             *                     This option is required for publicly trusted certificates.
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     The <code>ListHostedZones</code> API returns IDs in the format "/hostedzone/Z111111QQQQQQQ", but CloudFormation requires the IDs to be in the format "Z111111QQQQQQQ".
             *                     <p>
             *                     </blockquote>
             *                     <p>
             *                     When you change your <code>DomainValidationOptions</code> , a new resource is created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneId(java.lang.String hostedZoneId) {
                this.hostedZoneId = hostedZoneId;
                return this;
            }

            /**
             * Sets the value of {@link DomainValidationOptionProperty#getValidationDomain}
             * @param validationDomain The domain name to which you want ACM to send validation emails.
             *                         This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the <code>DomainName</code> value or a superdomain of the <code>DomainName</code> value. For example, if you request a certificate for <code>testing.example.com</code> , you can specify <code>example.com</code> as this value. In that case, ACM sends domain validation emails to the following five addresses:
             *                         <p>
             *                         <ul>
             *                         <li>admin&#64;example.com</li>
             *                         <li>administrator&#64;example.com</li>
             *                         <li>hostmaster&#64;example.com</li>
             *                         <li>postmaster&#64;example.com</li>
             *                         <li>webmaster&#64;example.com</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationDomain(java.lang.String validationDomain) {
                this.validationDomain = validationDomain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainValidationOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DomainValidationOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DomainValidationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainValidationOptionProperty {
            private final java.lang.String domainName;
            private final java.lang.String hostedZoneId;
            private final java.lang.String validationDomain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostedZoneId = software.amazon.jsii.Kernel.get(this, "hostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.validationDomain = software.amazon.jsii.Kernel.get(this, "validationDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
                this.hostedZoneId = builder.hostedZoneId;
                this.validationDomain = builder.validationDomain;
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.lang.String getHostedZoneId() {
                return this.hostedZoneId;
            }

            @Override
            public final java.lang.String getValidationDomain() {
                return this.validationDomain;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainName", om.valueToTree(this.getDomainName()));
                if (this.getHostedZoneId() != null) {
                    data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
                }
                if (this.getValidationDomain() != null) {
                    data.set("validationDomain", om.valueToTree(this.getValidationDomain()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-certificatemanager.CfnCertificate.DomainValidationOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainValidationOptionProperty.Jsii$Proxy that = (DomainValidationOptionProperty.Jsii$Proxy) o;

                if (!domainName.equals(that.domainName)) return false;
                if (this.hostedZoneId != null ? !this.hostedZoneId.equals(that.hostedZoneId) : that.hostedZoneId != null) return false;
                return this.validationDomain != null ? this.validationDomain.equals(that.validationDomain) : that.validationDomain == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainName.hashCode();
                result = 31 * result + (this.hostedZoneId != null ? this.hostedZoneId.hashCode() : 0);
                result = 31 * result + (this.validationDomain != null ? this.validationDomain.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.certificatemanager.CfnCertificate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.certificatemanager.CfnCertificate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.certificatemanager.CfnCertificateProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.certificatemanager.CfnCertificateProps.Builder();
        }

        /**
         * The fully qualified domain name (FQDN), such as www.example.com, with which you want to secure an ACM certificate. Use an asterisk (*) to create a wildcard certificate that protects several sites in the same domain. For example, `*.example.com` protects `www.example.com` , `site.example.com` , and `images.example.com.`.
         * <p>
         * @return {@code this}
         * @param domainName The fully qualified domain name (FQDN), such as www.example.com, with which you want to secure an ACM certificate. Use an asterisk (*) to create a wildcard certificate that protects several sites in the same domain. For example, `*.example.com` protects `www.example.com` , `site.example.com` , and `images.example.com.`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the private certificate authority (CA) that will be used to issue the certificate.
         * <p>
         * If you do not provide an ARN and you are trying to request a private certificate, ACM will attempt to issue a public certificate. For more information about private CAs, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaWelcome.html">AWS Certificate Manager Private Certificate Authority (PCA)</a> user guide. The ARN must have the following form:
         * <p>
         * <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code>
         * <p>
         * @return {@code this}
         * @param certificateAuthorityArn The Amazon Resource Name (ARN) of the private certificate authority (CA) that will be used to issue the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateAuthorityArn(final java.lang.String certificateAuthorityArn) {
            this.props.certificateAuthorityArn(certificateAuthorityArn);
            return this;
        }

        /**
         * You can opt out of certificate transparency logging by specifying the `DISABLED` option. Opt in by specifying `ENABLED` .
         * <p>
         * If you do not specify a certificate transparency logging preference on a new CloudFormation template, or if you remove the logging preference from an existing template, this is the same as explicitly enabling the preference.
         * <p>
         * Changing the certificate transparency logging preference will update the existing resource by calling <code>UpdateCertificateOptions</code> on the certificate. This action will not create a new resource.
         * <p>
         * @return {@code this}
         * @param certificateTransparencyLoggingPreference You can opt out of certificate transparency logging by specifying the `DISABLED` option. Opt in by specifying `ENABLED` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateTransparencyLoggingPreference(final java.lang.String certificateTransparencyLoggingPreference) {
            this.props.certificateTransparencyLoggingPreference(certificateTransparencyLoggingPreference);
            return this;
        }

        /**
         * Domain information that domain name registrars use to verify your identity.
         * <p>
         * <blockquote>
         * <p>
         * In order for a AWS::CertificateManager::Certificate to be provisioned and validated in CloudFormation automatically, the <code>DomainName</code> property needs to be identical to one of the <code>DomainName</code> property supplied in DomainValidationOptions, if the ValidationMethod is <strong>DNS</strong>. Failing to keep them like-for-like will result in failure to create the domain validation records in Route53.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param domainValidationOptions Domain information that domain name registrars use to verify your identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainValidationOptions(final software.amazon.awscdk.core.IResolvable domainValidationOptions) {
            this.props.domainValidationOptions(domainValidationOptions);
            return this;
        }
        /**
         * Domain information that domain name registrars use to verify your identity.
         * <p>
         * <blockquote>
         * <p>
         * In order for a AWS::CertificateManager::Certificate to be provisioned and validated in CloudFormation automatically, the <code>DomainName</code> property needs to be identical to one of the <code>DomainName</code> property supplied in DomainValidationOptions, if the ValidationMethod is <strong>DNS</strong>. Failing to keep them like-for-like will result in failure to create the domain validation records in Route53.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param domainValidationOptions Domain information that domain name registrars use to verify your identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainValidationOptions(final java.util.List<? extends java.lang.Object> domainValidationOptions) {
            this.props.domainValidationOptions(domainValidationOptions);
            return this;
        }

        /**
         * Additional FQDNs to be included in the Subject Alternative Name extension of the ACM certificate.
         * <p>
         * For example, you can add www.example.net to a certificate for which the <code>DomainName</code> field is www.example.com if users can reach your site by using either name.
         * <p>
         * @return {@code this}
         * @param subjectAlternativeNames Additional FQDNs to be included in the Subject Alternative Name extension of the ACM certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(final java.util.List<java.lang.String> subjectAlternativeNames) {
            this.props.subjectAlternativeNames(subjectAlternativeNames);
            return this;
        }

        /**
         * Key-value pairs that can identify the certificate.
         * <p>
         * @return {@code this}
         * @param tags Key-value pairs that can identify the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The method you want to use to validate that you own or control the domain associated with a public certificate.
         * <p>
         * You can <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">validate with DNS</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">validate with email</a> . We recommend that you use DNS validation.
         * <p>
         * If not specified, this property defaults to email validation.
         * <p>
         * @return {@code this}
         * @param validationMethod The method you want to use to validate that you own or control the domain associated with a public certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationMethod(final java.lang.String validationMethod) {
            this.props.validationMethod(validationMethod);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.certificatemanager.CfnCertificate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.certificatemanager.CfnCertificate build() {
            return new software.amazon.awscdk.services.certificatemanager.CfnCertificate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
