package software.amazon.awscdk.services.certificatemanager;

/**
 * A certificate managed by AWS Certificate Manager.
 * 
 * IMPORTANT: if you are creating a certificate as part of your stack, the stack
 * will not complete creating until you read and follow the instructions in the
 * email that you will receive.
 * 
 * ACM will send validation emails to the following addresses:
 * 
 *   admin@domain.com
 *   administrator@domain.com
 *   hostmaster@domain.com
 *   postmaster@domain.com
 *   webmaster@domain.com
 * 
 * For every domain that you register.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:05.107Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.Certificate")
public class Certificate extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.certificatemanager.ICertificate {

    protected Certificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Certificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Certificate(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.certificatemanager.CertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a certificate.
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param certificateArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.certificatemanager.ICertificate fromCertificateArn(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String certificateArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.certificatemanager.Certificate.class, "fromCertificateArn", software.amazon.awscdk.services.certificatemanager.ICertificate.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(certificateArn, "certificateArn is required") });
    }

    /**
     * The certificate's ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getCertificateArn() {
        return this.jsiiGet("certificateArn", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.certificatemanager.Certificate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.certificatemanager.CertificateProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.certificatemanager.CertificateProps.Builder();
        }

        /**
         * @return {@code this}
         * @param domainName Fully-qualified domain name to request a certificate for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * @return {@code this}
         * @param subjectAlternativeNames Alternative domain names on your certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(final java.util.List<java.lang.String> subjectAlternativeNames) {
            this.props.subjectAlternativeNames(subjectAlternativeNames);
            return this;
        }

        /**
         * @return {@code this}
         * @param validationDomains What validation domain to use for every requested domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationDomains(final java.util.Map<java.lang.String, java.lang.String> validationDomains) {
            this.props.validationDomains(validationDomains);
            return this;
        }

        /**
         * @return {@code this}
         * @param validationMethod Validation method used to assert domain ownership. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationMethod(final software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            this.props.validationMethod(validationMethod);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.certificatemanager.Certificate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.certificatemanager.Certificate build() {
            return new software.amazon.awscdk.services.certificatemanager.Certificate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
