package software.amazon.awscdk.services.certificatemanager;

/**
 * A certificate managed by AWS Certificate Manager.
 * <p>
 * Will be automatically
 * validated using DNS validation against the specified Route 53 hosted zone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone myHostedZone;
 * DnsValidatedCertificate.Builder.create(this, "CrossRegionCertificate")
 *         .domainName("hello.example.com")
 *         .hostedZone(myHostedZone)
 *         .region("us-east-1")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:06.242Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.DnsValidatedCertificate")
public class DnsValidatedCertificate extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.certificatemanager.ICertificate, software.amazon.awscdk.core.ITaggable {

    protected DnsValidatedCertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DnsValidatedCertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DnsValidatedCertificate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Return the DaysToExpiry metric for this AWS Certificate Manager Certificate. By default, this is the minimum value over 1 day.
     * <p>
     * This metric is no longer emitted once the certificate has effectively
     * expired, so alarms configured on this metric should probably treat missing
     * data as "breaching".
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDaysToExpiry(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricDaysToExpiry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Return the DaysToExpiry metric for this AWS Certificate Manager Certificate. By default, this is the minimum value over 1 day.
     * <p>
     * This metric is no longer emitted once the certificate has effectively
     * expired, so alarms configured on this metric should probably treat missing
     * data as "breaching".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDaysToExpiry() {
        return software.amazon.jsii.Kernel.call(this, "metricDaysToExpiry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The certificate's ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCertificateArn() {
        return software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Resource Tags.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-tags">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-tags</a>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * If the certificate is provisionned in a different region than the containing stack, this should be the region in which the certificate lives so we can correctly create `Metric` instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps.Builder();
        }

        /**
         * Fully-qualified domain name to request a certificate for.
         * <p>
         * May contain wildcards, such as <code>*.domain.com</code>.
         * <p>
         * @return {@code this}
         * @param domainName Fully-qualified domain name to request a certificate for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * Alternative domain names on your certificate.
         * <p>
         * Use this to register alternative domain names that represent the same site.
         * <p>
         * Default: - No additional FQDNs will be included as alternative domain names.
         * <p>
         * @return {@code this}
         * @param subjectAlternativeNames Alternative domain names on your certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(final java.util.List<java.lang.String> subjectAlternativeNames) {
            this.props.subjectAlternativeNames(subjectAlternativeNames);
            return this;
        }

        /**
         * How to validate this certificate.
         * <p>
         * Default: CertificateValidation.fromEmail()
         * <p>
         * @return {@code this}
         * @param validation How to validate this certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validation(final software.amazon.awscdk.services.certificatemanager.CertificateValidation validation) {
            this.props.validation(validation);
            return this;
        }

        /**
         * (deprecated) What validation domain to use for every requested domain.
         * <p>
         * Has to be a superdomain of the requested domain.
         * <p>
         * Default: - Apex domain is used for every domain that's not overridden.
         * <p>
         * @return {@code this}
         * @deprecated use `validation` instead.
         * @param validationDomains What validation domain to use for every requested domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder validationDomains(final java.util.Map<java.lang.String, java.lang.String> validationDomains) {
            this.props.validationDomains(validationDomains);
            return this;
        }

        /**
         * (deprecated) Validation method used to assert domain ownership.
         * <p>
         * Default: ValidationMethod.EMAIL
         * <p>
         * @return {@code this}
         * @deprecated use `validation` instead.
         * @param validationMethod Validation method used to assert domain ownership. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder validationMethod(final software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            this.props.validationMethod(validationMethod);
            return this;
        }

        /**
         * Route 53 Hosted Zone used to perform DNS validation of the request.
         * <p>
         * The zone
         * must be authoritative for the domain name specified in the Certificate Request.
         * <p>
         * @return {@code this}
         * @param hostedZone Route 53 Hosted Zone used to perform DNS validation of the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZone(final software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.props.hostedZone(hostedZone);
            return this;
        }

        /**
         * When set to true, when the DnsValidatedCertificate is deleted, the associated Route53 validation records are removed.
         * <p>
         * CAUTION: If multiple certificates share the same domains (and same validation records),
         * this can cause the other certificates to fail renewal and/or not validate.
         * Not recommended for production use.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param cleanupRoute53Records When set to true, when the DnsValidatedCertificate is deleted, the associated Route53 validation records are removed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cleanupRoute53Records(final java.lang.Boolean cleanupRoute53Records) {
            this.props.cleanupRoute53Records(cleanupRoute53Records);
            return this;
        }

        /**
         * Role to use for the custom resource that creates the validated certificate.
         * <p>
         * Default: - A new role will be created
         * <p>
         * @return {@code this}
         * @param customResourceRole Role to use for the custom resource that creates the validated certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customResourceRole(final software.amazon.awscdk.services.iam.IRole customResourceRole) {
            this.props.customResourceRole(customResourceRole);
            return this;
        }

        /**
         * AWS region that will host the certificate.
         * <p>
         * This is needed especially
         * for certificates used for CloudFront distributions, which require the region
         * to be us-east-1.
         * <p>
         * Default: the region the stack is deployed in.
         * <p>
         * @return {@code this}
         * @param region AWS region that will host the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * An endpoint of Route53 service, which is not necessary as AWS SDK could figure out the right endpoints for most regions, but for some regions such as those in aws-cn partition, the default endpoint is not working now, hence the right endpoint need to be specified through this prop.
         * <p>
         * Route53 is not been officially launched in China, it is only available for AWS
         * internal accounts now. To make DnsValidatedCertificate work for internal accounts
         * now, a special endpoint needs to be provided.
         * <p>
         * Default: - The AWS SDK will determine the Route53 endpoint to use based on region
         * <p>
         * @return {@code this}
         * @param route53Endpoint An endpoint of Route53 service, which is not necessary as AWS SDK could figure out the right endpoints for most regions, but for some regions such as those in aws-cn partition, the default endpoint is not working now, hence the right endpoint need to be specified through this prop. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder route53Endpoint(final java.lang.String route53Endpoint) {
            this.props.route53Endpoint(route53Endpoint);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate build() {
            return new software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
