package software.amazon.awscdk.services.certificatemanager;

/**
 * Properties for your private certificate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.acmpca.*;
 * PrivateCertificate.Builder.create(this, "PrivateCertificate")
 *         .domainName("test.example.com")
 *         .subjectAlternativeNames(List.of("cool.example.com", "test.example.net")) // optional
 *         .certificateAuthority(CertificateAuthority.fromCertificateAuthorityArn(this, "CA", "arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/023077d8-2bfa-4eb0-8f22-05c96deade77"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:23.085Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.PrivateCertificateProps")
@software.amazon.jsii.Jsii.Proxy(PrivateCertificateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PrivateCertificateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Private certificate authority (CA) that will be used to issue the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.acmpca.ICertificateAuthority getCertificateAuthority();

    /**
     * Fully-qualified domain name to request a private certificate for.
     * <p>
     * May contain wildcards, such as <code>*.domain.com</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * Alternative domain names on your private certificate.
     * <p>
     * Use this to register alternative domain names that represent the same site.
     * <p>
     * Default: - No additional FQDNs will be included as alternative domain names.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubjectAlternativeNames() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PrivateCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PrivateCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PrivateCertificateProps> {
        software.amazon.awscdk.services.acmpca.ICertificateAuthority certificateAuthority;
        java.lang.String domainName;
        java.util.List<java.lang.String> subjectAlternativeNames;

        /**
         * Sets the value of {@link PrivateCertificateProps#getCertificateAuthority}
         * @param certificateAuthority Private certificate authority (CA) that will be used to issue the certificate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateAuthority(software.amazon.awscdk.services.acmpca.ICertificateAuthority certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        /**
         * Sets the value of {@link PrivateCertificateProps#getDomainName}
         * @param domainName Fully-qualified domain name to request a private certificate for. This parameter is required.
         *                   May contain wildcards, such as <code>*.domain.com</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link PrivateCertificateProps#getSubjectAlternativeNames}
         * @param subjectAlternativeNames Alternative domain names on your private certificate.
         *                                Use this to register alternative domain names that represent the same site.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(java.util.List<java.lang.String> subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PrivateCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PrivateCertificateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PrivateCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateCertificateProps {
        private final software.amazon.awscdk.services.acmpca.ICertificateAuthority certificateAuthority;
        private final java.lang.String domainName;
        private final java.util.List<java.lang.String> subjectAlternativeNames;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificateAuthority = software.amazon.jsii.Kernel.get(this, "certificateAuthority", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.acmpca.ICertificateAuthority.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subjectAlternativeNames = software.amazon.jsii.Kernel.get(this, "subjectAlternativeNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificateAuthority = java.util.Objects.requireNonNull(builder.certificateAuthority, "certificateAuthority is required");
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.subjectAlternativeNames = builder.subjectAlternativeNames;
        }

        @Override
        public final software.amazon.awscdk.services.acmpca.ICertificateAuthority getCertificateAuthority() {
            return this.certificateAuthority;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("certificateAuthority", om.valueToTree(this.getCertificateAuthority()));
            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getSubjectAlternativeNames() != null) {
                data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-certificatemanager.PrivateCertificateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PrivateCertificateProps.Jsii$Proxy that = (PrivateCertificateProps.Jsii$Proxy) o;

            if (!certificateAuthority.equals(that.certificateAuthority)) return false;
            if (!domainName.equals(that.domainName)) return false;
            return this.subjectAlternativeNames != null ? this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames == null;
        }

        @Override
        public final int hashCode() {
            int result = this.certificateAuthority.hashCode();
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
            return result;
        }
    }
}
