package software.amazon.awscdk.services.certificatemanager;

/**
 * Properties for defining a `CfnCertificate`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.certificatemanager.*;
 * CfnCertificateProps cfnCertificateProps = CfnCertificateProps.builder()
 *         .domainName("domainName")
 *         // the properties below are optional
 *         .certificateAuthorityArn("certificateAuthorityArn")
 *         .certificateTransparencyLoggingPreference("certificateTransparencyLoggingPreference")
 *         .domainValidationOptions(List.of(DomainValidationOptionProperty.builder()
 *                 .domainName("domainName")
 *                 // the properties below are optional
 *                 .hostedZoneId("hostedZoneId")
 *                 .validationDomain("validationDomain")
 *                 .build()))
 *         .subjectAlternativeNames(List.of("subjectAlternativeNames"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .validationMethod("validationMethod")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-14T16:25:31.779Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.CfnCertificateProps")
@software.amazon.jsii.Jsii.Proxy(CfnCertificateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCertificateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The fully qualified domain name (FQDN), such as www.example.com, with which you want to secure an ACM certificate. Use an asterisk (*) to create a wildcard certificate that protects several sites in the same domain. For example, `*.example.com` protects `www.example.com` , `site.example.com` , and `images.example.com.`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The Amazon Resource Name (ARN) of the private certificate authority (CA) that will be used to issue the certificate.
     * <p>
     * If you do not provide an ARN and you are trying to request a private certificate, ACM will attempt to issue a public certificate. For more information about private CAs, see the <a href="https://docs.aws.amazon.com/privateca/latest/userguide/PcaWelcome.html">AWS Private Certificate Authority</a> user guide. The ARN must have the following form:
     * <p>
     * <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificateAuthorityArn() {
        return null;
    }

    /**
     * You can opt out of certificate transparency logging by specifying the `DISABLED` option. Opt in by specifying `ENABLED` .
     * <p>
     * If you do not specify a certificate transparency logging preference on a new CloudFormation template, or if you remove the logging preference from an existing template, this is the same as explicitly enabling the preference.
     * <p>
     * Changing the certificate transparency logging preference will update the existing resource by calling <code>UpdateCertificateOptions</code> on the certificate. This action will not create a new resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificateTransparencyLoggingPreference() {
        return null;
    }

    /**
     * Domain information that domain name registrars use to verify your identity.
     * <p>
     * <blockquote>
     * <p>
     * In order for a AWS::CertificateManager::Certificate to be provisioned and validated in CloudFormation automatically, the <code>DomainName</code> property needs to be identical to one of the <code>DomainName</code> property supplied in DomainValidationOptions, if the ValidationMethod is <strong>DNS</strong>. Failing to keep them like-for-like will result in failure to create the domain validation records in Route53.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDomainValidationOptions() {
        return null;
    }

    /**
     * Additional FQDNs to be included in the Subject Alternative Name extension of the ACM certificate.
     * <p>
     * For example, you can add www.example.net to a certificate for which the <code>DomainName</code> field is www.example.com if users can reach your site by using either name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubjectAlternativeNames() {
        return null;
    }

    /**
     * Key-value pairs that can identify the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * The method you want to use to validate that you own or control the domain associated with a public certificate.
     * <p>
     * You can <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">validate with DNS</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">validate with email</a> . We recommend that you use DNS validation.
     * <p>
     * If not specified, this property defaults to email validation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getValidationMethod() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCertificateProps> {
        java.lang.String domainName;
        java.lang.String certificateAuthorityArn;
        java.lang.String certificateTransparencyLoggingPreference;
        java.lang.Object domainValidationOptions;
        java.util.List<java.lang.String> subjectAlternativeNames;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.String validationMethod;

        /**
         * Sets the value of {@link CfnCertificateProps#getDomainName}
         * @param domainName The fully qualified domain name (FQDN), such as www.example.com, with which you want to secure an ACM certificate. Use an asterisk (*) to create a wildcard certificate that protects several sites in the same domain. For example, `*.example.com` protects `www.example.com` , `site.example.com` , and `images.example.com.`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getCertificateAuthorityArn}
         * @param certificateAuthorityArn The Amazon Resource Name (ARN) of the private certificate authority (CA) that will be used to issue the certificate.
         *                                If you do not provide an ARN and you are trying to request a private certificate, ACM will attempt to issue a public certificate. For more information about private CAs, see the <a href="https://docs.aws.amazon.com/privateca/latest/userguide/PcaWelcome.html">AWS Private Certificate Authority</a> user guide. The ARN must have the following form:
         *                                <p>
         *                                <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateAuthorityArn(java.lang.String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getCertificateTransparencyLoggingPreference}
         * @param certificateTransparencyLoggingPreference You can opt out of certificate transparency logging by specifying the `DISABLED` option. Opt in by specifying `ENABLED` .
         *                                                 If you do not specify a certificate transparency logging preference on a new CloudFormation template, or if you remove the logging preference from an existing template, this is the same as explicitly enabling the preference.
         *                                                 <p>
         *                                                 Changing the certificate transparency logging preference will update the existing resource by calling <code>UpdateCertificateOptions</code> on the certificate. This action will not create a new resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateTransparencyLoggingPreference(java.lang.String certificateTransparencyLoggingPreference) {
            this.certificateTransparencyLoggingPreference = certificateTransparencyLoggingPreference;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getDomainValidationOptions}
         * @param domainValidationOptions Domain information that domain name registrars use to verify your identity.
         *                                <blockquote>
         *                                <p>
         *                                In order for a AWS::CertificateManager::Certificate to be provisioned and validated in CloudFormation automatically, the <code>DomainName</code> property needs to be identical to one of the <code>DomainName</code> property supplied in DomainValidationOptions, if the ValidationMethod is <strong>DNS</strong>. Failing to keep them like-for-like will result in failure to create the domain validation records in Route53.
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainValidationOptions(software.amazon.awscdk.core.IResolvable domainValidationOptions) {
            this.domainValidationOptions = domainValidationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getDomainValidationOptions}
         * @param domainValidationOptions Domain information that domain name registrars use to verify your identity.
         *                                <blockquote>
         *                                <p>
         *                                In order for a AWS::CertificateManager::Certificate to be provisioned and validated in CloudFormation automatically, the <code>DomainName</code> property needs to be identical to one of the <code>DomainName</code> property supplied in DomainValidationOptions, if the ValidationMethod is <strong>DNS</strong>. Failing to keep them like-for-like will result in failure to create the domain validation records in Route53.
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainValidationOptions(java.util.List<? extends java.lang.Object> domainValidationOptions) {
            this.domainValidationOptions = domainValidationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getSubjectAlternativeNames}
         * @param subjectAlternativeNames Additional FQDNs to be included in the Subject Alternative Name extension of the ACM certificate.
         *                                For example, you can add www.example.net to a certificate for which the <code>DomainName</code> field is www.example.com if users can reach your site by using either name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(java.util.List<java.lang.String> subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getTags}
         * @param tags Key-value pairs that can identify the certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getValidationMethod}
         * @param validationMethod The method you want to use to validate that you own or control the domain associated with a public certificate.
         *                         You can <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">validate with DNS</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">validate with email</a> . We recommend that you use DNS validation.
         *                         <p>
         *                         If not specified, this property defaults to email validation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationMethod(java.lang.String validationMethod) {
            this.validationMethod = validationMethod;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCertificateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCertificateProps {
        private final java.lang.String domainName;
        private final java.lang.String certificateAuthorityArn;
        private final java.lang.String certificateTransparencyLoggingPreference;
        private final java.lang.Object domainValidationOptions;
        private final java.util.List<java.lang.String> subjectAlternativeNames;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String validationMethod;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateAuthorityArn = software.amazon.jsii.Kernel.get(this, "certificateAuthorityArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateTransparencyLoggingPreference = software.amazon.jsii.Kernel.get(this, "certificateTransparencyLoggingPreference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainValidationOptions = software.amazon.jsii.Kernel.get(this, "domainValidationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subjectAlternativeNames = software.amazon.jsii.Kernel.get(this, "subjectAlternativeNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.validationMethod = software.amazon.jsii.Kernel.get(this, "validationMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.certificateAuthorityArn = builder.certificateAuthorityArn;
            this.certificateTransparencyLoggingPreference = builder.certificateTransparencyLoggingPreference;
            this.domainValidationOptions = builder.domainValidationOptions;
            this.subjectAlternativeNames = builder.subjectAlternativeNames;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.validationMethod = builder.validationMethod;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        @Override
        public final java.lang.String getCertificateTransparencyLoggingPreference() {
            return this.certificateTransparencyLoggingPreference;
        }

        @Override
        public final java.lang.Object getDomainValidationOptions() {
            return this.domainValidationOptions;
        }

        @Override
        public final java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getValidationMethod() {
            return this.validationMethod;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getCertificateAuthorityArn() != null) {
                data.set("certificateAuthorityArn", om.valueToTree(this.getCertificateAuthorityArn()));
            }
            if (this.getCertificateTransparencyLoggingPreference() != null) {
                data.set("certificateTransparencyLoggingPreference", om.valueToTree(this.getCertificateTransparencyLoggingPreference()));
            }
            if (this.getDomainValidationOptions() != null) {
                data.set("domainValidationOptions", om.valueToTree(this.getDomainValidationOptions()));
            }
            if (this.getSubjectAlternativeNames() != null) {
                data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getValidationMethod() != null) {
                data.set("validationMethod", om.valueToTree(this.getValidationMethod()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-certificatemanager.CfnCertificateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCertificateProps.Jsii$Proxy that = (CfnCertificateProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (this.certificateAuthorityArn != null ? !this.certificateAuthorityArn.equals(that.certificateAuthorityArn) : that.certificateAuthorityArn != null) return false;
            if (this.certificateTransparencyLoggingPreference != null ? !this.certificateTransparencyLoggingPreference.equals(that.certificateTransparencyLoggingPreference) : that.certificateTransparencyLoggingPreference != null) return false;
            if (this.domainValidationOptions != null ? !this.domainValidationOptions.equals(that.domainValidationOptions) : that.domainValidationOptions != null) return false;
            if (this.subjectAlternativeNames != null ? !this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.validationMethod != null ? this.validationMethod.equals(that.validationMethod) : that.validationMethod == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.certificateAuthorityArn != null ? this.certificateAuthorityArn.hashCode() : 0);
            result = 31 * result + (this.certificateTransparencyLoggingPreference != null ? this.certificateTransparencyLoggingPreference.hashCode() : 0);
            result = 31 * result + (this.domainValidationOptions != null ? this.domainValidationOptions.hashCode() : 0);
            result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.validationMethod != null ? this.validationMethod.hashCode() : 0);
            return result;
        }
    }
}
