package software.amazon.awscdk.services.certificatemanager;

/**
 * A certificate managed by AWS Certificate Manager.
 * <p>
 * Will be automatically
 * validated using DNS validation against the specified Route 53 hosted zone.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-13T18:54:01.404Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.DnsValidatedCertificate")
public class DnsValidatedCertificate extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.certificatemanager.ICertificate {

    protected DnsValidatedCertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DnsValidatedCertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DnsValidatedCertificate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The certificate's ARN.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getCertificateArn() {
        return this.jsiiGet("certificateArn", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps.Builder();
        }

        /**
         * Fully-qualified domain name to request a certificate for.
         * <p>
         * May contain wildcards, such as <code>*.domain.com</code>.
         * <p>
         * @return {@code this}
         * @param domainName Fully-qualified domain name to request a certificate for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * Alternative domain names on your certificate.
         * <p>
         * Use this to register alternative domain names that represent the same site.
         * <p>
         * Default: - No additional FQDNs will be included as alternative domain names.
         * <p>
         * @return {@code this}
         * @param subjectAlternativeNames Alternative domain names on your certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(final java.util.List<java.lang.String> subjectAlternativeNames) {
            this.props.subjectAlternativeNames(subjectAlternativeNames);
            return this;
        }

        /**
         * What validation domain to use for every requested domain.
         * <p>
         * Has to be a superdomain of the requested domain.
         * <p>
         * Default: - Apex domain is used for every domain that's not overridden.
         * <p>
         * @return {@code this}
         * @param validationDomains What validation domain to use for every requested domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationDomains(final java.util.Map<java.lang.String, java.lang.String> validationDomains) {
            this.props.validationDomains(validationDomains);
            return this;
        }

        /**
         * Validation method used to assert domain ownership.
         * <p>
         * Default: ValidationMethod.EMAIL
         * <p>
         * @return {@code this}
         * @param validationMethod Validation method used to assert domain ownership. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationMethod(final software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            this.props.validationMethod(validationMethod);
            return this;
        }

        /**
         * Route 53 Hosted Zone used to perform DNS validation of the request.
         * <p>
         * The zone
         * must be authoritative for the domain name specified in the Certificate Request.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param hostedZone Route 53 Hosted Zone used to perform DNS validation of the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hostedZone(final software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.props.hostedZone(hostedZone);
            return this;
        }

        /**
         * Role to use for the custom resource that creates the validated certificate.
         * <p>
         * Default: - A new role will be created
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param customResourceRole Role to use for the custom resource that creates the validated certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customResourceRole(final software.amazon.awscdk.services.iam.IRole customResourceRole) {
            this.props.customResourceRole(customResourceRole);
            return this;
        }

        /**
         * AWS region that will host the certificate.
         * <p>
         * This is needed especially
         * for certificates used for CloudFront distributions, which require the region
         * to be us-east-1.
         * <p>
         * Default: the region the stack is deployed in.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param region AWS region that will host the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate build() {
            return new software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
