/**
 * <h2>Amazon Certificate Manager Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="Stability: Stable" src="https://img.shields.io/badge/stability-Stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This package provides Constructs for provisioning and referencing
 * certificates which can be used in CloudFront and ELB.
 * <p>
 * The following requests a certificate for a given domain:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Certificate cert = new Certificate(this, "Certificate", new CertificateProps()
 *         .domainName("example.com"));
 * </pre></blockquote>
 * <p>
 * After requesting a certificate, you will need to prove that you own the
 * domain in question before the certificate will be granted. The CloudFormation
 * deployment will wait until this verification process has been completed.
 * <p>
 * Because of this wait time, it's better to provision your certificates
 * either in a separate stack from your main service, or provision them
 * manually and import them into your CDK application.
 * <p>
 * The CDK also provides a custom resource which can be used for automatic
 * validation if the DNS records for the domain are managed through Route53 (see
 * below).
 * <p>
 * <h3>Email validation</h3>
 * <p>
 * Email-validated certificates (the default) are validated by receiving an
 * email on one of a number of predefined domains and following the instructions
 * in the email.
 * <p>
 * See <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">Validate with Email</a>
 * in the Amazon Certificate Manager User Guide.
 * <p>
 * <h3>DNS validation</h3>
 * <p>
 * DNS-validated certificates are validated by configuring appropriate DNS
 * records for your domain.
 * <p>
 * See <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">Validate with DNS</a>
 * in the Amazon Certificate Manager User Guide.
 * <p>
 * <h3>Automatic DNS-validated certificates using Route53</h3>
 * <p>
 * The <code>DnsValidatedCertificateRequest</code> class provides a Custom Resource by which
 * you can request a TLS certificate from AWS Certificate Manager that is
 * automatically validated using a cryptographically secure DNS record. For this to
 * work, there must be a Route 53 public zone that is responsible for serving
 * records under the Domain Name of the requested certificate. For example, if you
 * request a certificate for <code>www.example.com</code>, there must be a Route 53 public
 * zone <code>example.com</code> that provides authoritative records for the domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * IHostedZone hostedZone = route53.HostedZone.fromLookup(this, "HostedZone", new HostedZoneProviderProps()
 *         .domainName("example.com")
 *         .privateZone(false));
 * 
 * DnsValidatedCertificate certificate = new DnsValidatedCertificate(this, "TestCertificate", new DnsValidatedCertificateProps()
 *         .domainName("test.example.com")
 *         .hostedZone(hostedZone));
 * </pre></blockquote>
 * <p>
 * <h3>Importing</h3>
 * <p>
 * If you want to import an existing certificate, you can do so from its ARN:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * String arn = "arn:aws:...";
 * var certificate = Certificate.fromCertificateArn(this, "Certificate", arn);
 * </pre></blockquote>
 * <p>
 * <h3>Sharing between Stacks</h3>
 * <p>
 * To share the certificate between stacks in the same CDK application, simply
 * pass the <code>Certificate</code> object between the stacks.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.certificatemanager;
