package software.amazon.awscdk.services.certificatemanager;

/**
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-02T10:18:38.172Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DnsValidatedCertificateProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.certificatemanager.CertificateProps {
    /**
     * Route 53 Hosted Zone used to perform DNS validation of the request.
     * 
     * The zone
     * must be authoritative for the domain name specified in the Certificate Request.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.route53.IHostedZone getHostedZone();
    /**
     * AWS region that will host the certificate.
     * 
     * This is needed especially
     * for certificates used for CloudFront distributions, which require the region
     * to be us-east-1.
     * 
     * Default: the region the stack is deployed in.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getRegion();

    /**
     * @return a {@link Builder} of {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private software.amazon.awscdk.services.route53.IHostedZone _hostedZone;
        @javax.annotation.Nullable
        private java.lang.String _region;
        private java.lang.String _domainName;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _subjectAlternativeNames;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _validationDomains;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.certificatemanager.ValidationMethod _validationMethod;

        /**
         * Sets the value of HostedZone
         * @param value Route 53 Hosted Zone used to perform DNS validation of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withHostedZone(final software.amazon.awscdk.services.route53.IHostedZone value) {
            this._hostedZone = java.util.Objects.requireNonNull(value, "hostedZone is required");
            return this;
        }
        /**
         * Sets the value of Region
         * @param value AWS region that will host the certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withRegion(@javax.annotation.Nullable final java.lang.String value) {
            this._region = value;
            return this;
        }
        /**
         * Sets the value of DomainName
         * @param value Fully-qualified domain name to request a certificate for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDomainName(final java.lang.String value) {
            this._domainName = java.util.Objects.requireNonNull(value, "domainName is required");
            return this;
        }
        /**
         * Sets the value of SubjectAlternativeNames
         * @param value Alternative domain names on your certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSubjectAlternativeNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._subjectAlternativeNames = value;
            return this;
        }
        /**
         * Sets the value of ValidationDomains
         * @param value What validation domain to use for every requested domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withValidationDomains(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._validationDomains = value;
            return this;
        }
        /**
         * Sets the value of ValidationMethod
         * @param value Validation method used to assert domain ownership.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withValidationMethod(@javax.annotation.Nullable final software.amazon.awscdk.services.certificatemanager.ValidationMethod value) {
            this._validationMethod = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DnsValidatedCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public DnsValidatedCertificateProps build() {
            return new DnsValidatedCertificateProps() {
                private final software.amazon.awscdk.services.route53.IHostedZone $hostedZone = java.util.Objects.requireNonNull(_hostedZone, "hostedZone is required");
                @javax.annotation.Nullable
                private final java.lang.String $region = _region;
                private final java.lang.String $domainName = java.util.Objects.requireNonNull(_domainName, "domainName is required");
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $subjectAlternativeNames = _subjectAlternativeNames;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $validationDomains = _validationDomains;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.certificatemanager.ValidationMethod $validationMethod = _validationMethod;

                @Override
                public software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
                    return this.$hostedZone;
                }

                @Override
                public java.lang.String getRegion() {
                    return this.$region;
                }

                @Override
                public java.lang.String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public java.util.List<java.lang.String> getSubjectAlternativeNames() {
                    return this.$subjectAlternativeNames;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
                    return this.$validationDomains;
                }

                @Override
                public software.amazon.awscdk.services.certificatemanager.ValidationMethod getValidationMethod() {
                    return this.$validationMethod;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("hostedZone", om.valueToTree(this.getHostedZone()));
                    if (this.getRegion() != null) {
                        obj.set("region", om.valueToTree(this.getRegion()));
                    }
                    obj.set("domainName", om.valueToTree(this.getDomainName()));
                    if (this.getSubjectAlternativeNames() != null) {
                        obj.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
                    }
                    if (this.getValidationDomains() != null) {
                        obj.set("validationDomains", om.valueToTree(this.getValidationDomains()));
                    }
                    if (this.getValidationMethod() != null) {
                        obj.set("validationMethod", om.valueToTree(this.getValidationMethod()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Route 53 Hosted Zone used to perform DNS validation of the request.
         * 
         * The zone
         * must be authoritative for the domain name specified in the Certificate Request.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
            return this.jsiiGet("hostedZone", software.amazon.awscdk.services.route53.IHostedZone.class);
        }

        /**
         * AWS region that will host the certificate.
         * 
         * This is needed especially
         * for certificates used for CloudFront distributions, which require the region
         * to be us-east-1.
         * 
         * Default: the region the stack is deployed in.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getRegion() {
            return this.jsiiGet("region", java.lang.String.class);
        }

        /**
         * Fully-qualified domain name to request a certificate for.
         * 
         * May contain wildcards, such as ``*.domain.com``.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getDomainName() {
            return this.jsiiGet("domainName", java.lang.String.class);
        }

        /**
         * Alternative domain names on your certificate.
         * 
         * Use this to register alternative domain names that represent the same site.
         * 
         * Default: - No additional FQDNs will be included as alternative domain names.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.jsiiGet("subjectAlternativeNames", java.util.List.class);
        }

        /**
         * What validation domain to use for every requested domain.
         * 
         * Has to be a superdomain of the requested domain.
         * 
         * Default: - Apex domain is used for every domain that's not overridden.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this.jsiiGet("validationDomains", java.util.Map.class);
        }

        /**
         * Validation method used to assert domain ownership.
         * 
         * Default: ValidationMethod.EMAIL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.certificatemanager.ValidationMethod getValidationMethod() {
            return this.jsiiGet("validationMethod", software.amazon.awscdk.services.certificatemanager.ValidationMethod.class);
        }
    }
}
