package software.amazon.awscdk.services.certificatemanager;

/**
 * Properties to create a DNS validated certificate managed by AWS Certificate Manager.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-06-30T10:27:09.368Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.DnsValidatedCertificateProps")
@software.amazon.jsii.Jsii.Proxy(DnsValidatedCertificateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DnsValidatedCertificateProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.certificatemanager.CertificateProps {

    /**
     * Route 53 Hosted Zone used to perform DNS validation of the request.
     * <p>
     * The zone
     * must be authoritative for the domain name specified in the Certificate Request.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone getHostedZone();

    /**
     * Role to use for the custom resource that creates the validated certificate.
     * <p>
     * Default: - A new role will be created
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getCustomResourceRole() {
        return null;
    }

    /**
     * AWS region that will host the certificate.
     * <p>
     * This is needed especially
     * for certificates used for CloudFront distributions, which require the region
     * to be us-east-1.
     * <p>
     * Default: the region the stack is deployed in.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * An endpoint of Route53 service, which is not necessary as AWS SDK could figure out the right endpoints for most regions, but for some regions such as those in aws-cn partition, the default endpoint is not working now, hence the right endpoint need to be specified through this prop.
     * <p>
     * Route53 is not been offically launched in China, it is only available for AWS
     * internal accounts now. To make DnsValidatedCertificate work for internal accounts
     * now, a special endpoint needs to be provided.
     * <p>
     * Default: - The AWS SDK will determine the Route53 endpoint to use based on region
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoute53Endpoint() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DnsValidatedCertificateProps> {
        private software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        private software.amazon.awscdk.services.iam.IRole customResourceRole;
        private java.lang.String region;
        private java.lang.String route53Endpoint;
        private java.lang.String domainName;
        private java.util.List<java.lang.String> subjectAlternativeNames;
        private java.util.Map<java.lang.String, java.lang.String> validationDomains;
        private software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod;

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getHostedZone}
         * @param hostedZone Route 53 Hosted Zone used to perform DNS validation of the request. This parameter is required.
         *                   The zone
         *                   must be authoritative for the domain name specified in the Certificate Request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hostedZone(software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getCustomResourceRole}
         * @param customResourceRole Role to use for the custom resource that creates the validated certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customResourceRole(software.amazon.awscdk.services.iam.IRole customResourceRole) {
            this.customResourceRole = customResourceRole;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getRegion}
         * @param region AWS region that will host the certificate.
         *               This is needed especially
         *               for certificates used for CloudFront distributions, which require the region
         *               to be us-east-1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getRoute53Endpoint}
         * @param route53Endpoint An endpoint of Route53 service, which is not necessary as AWS SDK could figure out the right endpoints for most regions, but for some regions such as those in aws-cn partition, the default endpoint is not working now, hence the right endpoint need to be specified through this prop.
         *                        Route53 is not been offically launched in China, it is only available for AWS
         *                        internal accounts now. To make DnsValidatedCertificate work for internal accounts
         *                        now, a special endpoint needs to be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder route53Endpoint(java.lang.String route53Endpoint) {
            this.route53Endpoint = route53Endpoint;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getDomainName}
         * @param domainName Fully-qualified domain name to request a certificate for. This parameter is required.
         *                   May contain wildcards, such as <code>*.domain.com</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getSubjectAlternativeNames}
         * @param subjectAlternativeNames Alternative domain names on your certificate.
         *                                Use this to register alternative domain names that represent the same site.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(java.util.List<java.lang.String> subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getValidationDomains}
         * @param validationDomains What validation domain to use for every requested domain.
         *                          Has to be a superdomain of the requested domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationDomains(java.util.Map<java.lang.String, java.lang.String> validationDomains) {
            this.validationDomains = validationDomains;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getValidationMethod}
         * @param validationMethod Validation method used to assert domain ownership.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationMethod(software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            this.validationMethod = validationMethod;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DnsValidatedCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DnsValidatedCertificateProps build() {
            return new Jsii$Proxy(hostedZone, customResourceRole, region, route53Endpoint, domainName, subjectAlternativeNames, validationDomains, validationMethod);
        }
    }

    /**
     * An implementation for {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DnsValidatedCertificateProps {
        private final software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        private final software.amazon.awscdk.services.iam.IRole customResourceRole;
        private final java.lang.String region;
        private final java.lang.String route53Endpoint;
        private final java.lang.String domainName;
        private final java.util.List<java.lang.String> subjectAlternativeNames;
        private final java.util.Map<java.lang.String, java.lang.String> validationDomains;
        private final software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostedZone = this.jsiiGet("hostedZone", software.amazon.awscdk.services.route53.IHostedZone.class);
            this.customResourceRole = this.jsiiGet("customResourceRole", software.amazon.awscdk.services.iam.IRole.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
            this.route53Endpoint = this.jsiiGet("route53Endpoint", java.lang.String.class);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.subjectAlternativeNames = this.jsiiGet("subjectAlternativeNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.validationDomains = this.jsiiGet("validationDomains", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.validationMethod = this.jsiiGet("validationMethod", software.amazon.awscdk.services.certificatemanager.ValidationMethod.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.route53.IHostedZone hostedZone, final software.amazon.awscdk.services.iam.IRole customResourceRole, final java.lang.String region, final java.lang.String route53Endpoint, final java.lang.String domainName, final java.util.List<java.lang.String> subjectAlternativeNames, final java.util.Map<java.lang.String, java.lang.String> validationDomains, final software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostedZone = java.util.Objects.requireNonNull(hostedZone, "hostedZone is required");
            this.customResourceRole = customResourceRole;
            this.region = region;
            this.route53Endpoint = route53Endpoint;
            this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
            this.subjectAlternativeNames = subjectAlternativeNames;
            this.validationDomains = validationDomains;
            this.validationMethod = validationMethod;
        }

        @Override
        public software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
            return this.hostedZone;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getCustomResourceRole() {
            return this.customResourceRole;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public java.lang.String getRoute53Endpoint() {
            return this.route53Endpoint;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this.validationDomains;
        }

        @Override
        public software.amazon.awscdk.services.certificatemanager.ValidationMethod getValidationMethod() {
            return this.validationMethod;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostedZone", om.valueToTree(this.getHostedZone()));
            if (this.getCustomResourceRole() != null) {
                data.set("customResourceRole", om.valueToTree(this.getCustomResourceRole()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getRoute53Endpoint() != null) {
                data.set("route53Endpoint", om.valueToTree(this.getRoute53Endpoint()));
            }
            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getSubjectAlternativeNames() != null) {
                data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
            }
            if (this.getValidationDomains() != null) {
                data.set("validationDomains", om.valueToTree(this.getValidationDomains()));
            }
            if (this.getValidationMethod() != null) {
                data.set("validationMethod", om.valueToTree(this.getValidationMethod()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-certificatemanager.DnsValidatedCertificateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DnsValidatedCertificateProps.Jsii$Proxy that = (DnsValidatedCertificateProps.Jsii$Proxy) o;

            if (!hostedZone.equals(that.hostedZone)) return false;
            if (this.customResourceRole != null ? !this.customResourceRole.equals(that.customResourceRole) : that.customResourceRole != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.route53Endpoint != null ? !this.route53Endpoint.equals(that.route53Endpoint) : that.route53Endpoint != null) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (this.subjectAlternativeNames != null ? !this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames != null) return false;
            if (this.validationDomains != null ? !this.validationDomains.equals(that.validationDomains) : that.validationDomains != null) return false;
            return this.validationMethod != null ? this.validationMethod.equals(that.validationMethod) : that.validationMethod == null;
        }

        @Override
        public int hashCode() {
            int result = this.hostedZone.hashCode();
            result = 31 * result + (this.customResourceRole != null ? this.customResourceRole.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.route53Endpoint != null ? this.route53Endpoint.hashCode() : 0);
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
            result = 31 * result + (this.validationDomains != null ? this.validationDomains.hashCode() : 0);
            result = 31 * result + (this.validationMethod != null ? this.validationMethod.hashCode() : 0);
            return result;
        }
    }
}
