package software.amazon.awscdk.services.certificatemanager;

/**
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-21T10:54:03.257Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DnsValidatedCertificateProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.certificatemanager.CertificateProps {
    /**
     * Route 53 Hosted Zone used to perform DNS validation of the request.
     * 
     * The zone
     * must be authoritative for the domain name specified in the Certificate Request.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.route53.IHostedZone getHostedZone();

    /**
     * AWS region that will host the certificate.
     * 
     * This is needed especially
     * for certificates used for CloudFront distributions, which require the region
     * to be us-east-1.
     * 
     * Default: the region the stack is deployed in.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getRegion();

    /**
     * @return a {@link Builder} of {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        private java.lang.String region;
        private java.lang.String domainName;
        private java.util.List<java.lang.String> subjectAlternativeNames;
        private java.util.Map<java.lang.String, java.lang.String> validationDomains;
        private software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod;

        /**
         * Sets the value of HostedZone
         * @param hostedZone Route 53 Hosted Zone used to perform DNS validation of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hostedZone(software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        /**
         * Sets the value of Region
         * @param region AWS region that will host the certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of DomainName
         * @param domainName Fully-qualified domain name to request a certificate for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of SubjectAlternativeNames
         * @param subjectAlternativeNames Alternative domain names on your certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(java.util.List<java.lang.String> subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        /**
         * Sets the value of ValidationDomains
         * @param validationDomains What validation domain to use for every requested domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationDomains(java.util.Map<java.lang.String, java.lang.String> validationDomains) {
            this.validationDomains = validationDomains;
            return this;
        }

        /**
         * Sets the value of ValidationMethod
         * @param validationMethod Validation method used to assert domain ownership.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationMethod(software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            this.validationMethod = validationMethod;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DnsValidatedCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public DnsValidatedCertificateProps build() {
            return new Jsii$Proxy(hostedZone, region, domainName, subjectAlternativeNames, validationDomains, validationMethod);
        }

    }

    /**
     * An implementation for {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DnsValidatedCertificateProps {
        private final software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        private final java.lang.String region;
        private final java.lang.String domainName;
        private final java.util.List<java.lang.String> subjectAlternativeNames;
        private final java.util.Map<java.lang.String, java.lang.String> validationDomains;
        private final software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.hostedZone = this.jsiiGet("hostedZone", software.amazon.awscdk.services.route53.IHostedZone.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.subjectAlternativeNames = this.jsiiGet("subjectAlternativeNames", java.util.List.class);
            this.validationDomains = this.jsiiGet("validationDomains", java.util.Map.class);
            this.validationMethod = this.jsiiGet("validationMethod", software.amazon.awscdk.services.certificatemanager.ValidationMethod.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.route53.IHostedZone hostedZone, java.lang.String region, java.lang.String domainName, java.util.List<java.lang.String> subjectAlternativeNames, java.util.Map<java.lang.String, java.lang.String> validationDomains, software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostedZone = java.util.Objects.requireNonNull(hostedZone, "hostedZone is required");
            this.region = region;
            this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
            this.subjectAlternativeNames = subjectAlternativeNames;
            this.validationDomains = validationDomains;
            this.validationMethod = validationMethod;
        }

        @Override
        public software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
            return this.hostedZone;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this.validationDomains;
        }

        @Override
        public software.amazon.awscdk.services.certificatemanager.ValidationMethod getValidationMethod() {
            return this.validationMethod;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("hostedZone", om.valueToTree(this.getHostedZone()));
            if (this.getRegion() != null) {
                obj.set("region", om.valueToTree(this.getRegion()));
            }
            obj.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getSubjectAlternativeNames() != null) {
                obj.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
            }
            if (this.getValidationDomains() != null) {
                obj.set("validationDomains", om.valueToTree(this.getValidationDomains()));
            }
            if (this.getValidationMethod() != null) {
                obj.set("validationMethod", om.valueToTree(this.getValidationMethod()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DnsValidatedCertificateProps.Jsii$Proxy that = (DnsValidatedCertificateProps.Jsii$Proxy) o;

            if (!hostedZone.equals(that.hostedZone)) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (this.subjectAlternativeNames != null ? !this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames != null) return false;
            if (this.validationDomains != null ? !this.validationDomains.equals(that.validationDomains) : that.validationDomains != null) return false;
            return this.validationMethod != null ? this.validationMethod.equals(that.validationMethod) : that.validationMethod == null;
        }

        @Override
        public int hashCode() {
            int result = this.hostedZone.hashCode();
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
            result = 31 * result + (this.validationDomains != null ? this.validationDomains.hashCode() : 0);
            result = 31 * result + (this.validationMethod != null ? this.validationMethod.hashCode() : 0);
            return result;
        }

    }
}
