package software.amazon.awscdk.services.certificatemanager;

/**
 * Properties for certificate validation.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-07T19:41:37.794Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.CertificationValidationProps")
@software.amazon.jsii.Jsii.Proxy(CertificationValidationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CertificationValidationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Hosted zone to use for DNS validation.
     * <p>
     * Default: - use email validation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
        return null;
    }

    /**
     * A map of hosted zones to use for DNS validation.
     * <p>
     * Default: - use `hostedZone`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.route53.IHostedZone> getHostedZones() {
        return null;
    }

    /**
     * Validation method.
     * <p>
     * Default: ValidationMethod.EMAIL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.ValidationMethod getMethod() {
        return null;
    }

    /**
     * Validation domains to use for email validation.
     * <p>
     * Default: - Apex domain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CertificationValidationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CertificationValidationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CertificationValidationProps> {
        private software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.route53.IHostedZone> hostedZones;
        private software.amazon.awscdk.services.certificatemanager.ValidationMethod method;
        private java.util.Map<java.lang.String, java.lang.String> validationDomains;

        /**
         * Sets the value of {@link CertificationValidationProps#getHostedZone}
         * @param hostedZone Hosted zone to use for DNS validation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZone(software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        /**
         * Sets the value of {@link CertificationValidationProps#getHostedZones}
         * @param hostedZones A map of hosted zones to use for DNS validation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZones(java.util.Map<java.lang.String, software.amazon.awscdk.services.route53.IHostedZone> hostedZones) {
            this.hostedZones = hostedZones;
            return this;
        }

        /**
         * Sets the value of {@link CertificationValidationProps#getMethod}
         * @param method Validation method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(software.amazon.awscdk.services.certificatemanager.ValidationMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link CertificationValidationProps#getValidationDomains}
         * @param validationDomains Validation domains to use for email validation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationDomains(java.util.Map<java.lang.String, java.lang.String> validationDomains) {
            this.validationDomains = validationDomains;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CertificationValidationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CertificationValidationProps build() {
            return new Jsii$Proxy(hostedZone, hostedZones, method, validationDomains);
        }
    }

    /**
     * An implementation for {@link CertificationValidationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificationValidationProps {
        private final software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.route53.IHostedZone> hostedZones;
        private final software.amazon.awscdk.services.certificatemanager.ValidationMethod method;
        private final java.util.Map<java.lang.String, java.lang.String> validationDomains;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostedZone = this.jsiiGet("hostedZone", software.amazon.awscdk.services.route53.IHostedZone.class);
            this.hostedZones = this.jsiiGet("hostedZones", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class)));
            this.method = this.jsiiGet("method", software.amazon.awscdk.services.certificatemanager.ValidationMethod.class);
            this.validationDomains = this.jsiiGet("validationDomains", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.route53.IHostedZone hostedZone, final java.util.Map<java.lang.String, software.amazon.awscdk.services.route53.IHostedZone> hostedZones, final software.amazon.awscdk.services.certificatemanager.ValidationMethod method, final java.util.Map<java.lang.String, java.lang.String> validationDomains) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostedZone = hostedZone;
            this.hostedZones = hostedZones;
            this.method = method;
            this.validationDomains = validationDomains;
        }

        @Override
        public software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
            return this.hostedZone;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.route53.IHostedZone> getHostedZones() {
            return this.hostedZones;
        }

        @Override
        public software.amazon.awscdk.services.certificatemanager.ValidationMethod getMethod() {
            return this.method;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this.validationDomains;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHostedZone() != null) {
                data.set("hostedZone", om.valueToTree(this.getHostedZone()));
            }
            if (this.getHostedZones() != null) {
                data.set("hostedZones", om.valueToTree(this.getHostedZones()));
            }
            if (this.getMethod() != null) {
                data.set("method", om.valueToTree(this.getMethod()));
            }
            if (this.getValidationDomains() != null) {
                data.set("validationDomains", om.valueToTree(this.getValidationDomains()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-certificatemanager.CertificationValidationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CertificationValidationProps.Jsii$Proxy that = (CertificationValidationProps.Jsii$Proxy) o;

            if (this.hostedZone != null ? !this.hostedZone.equals(that.hostedZone) : that.hostedZone != null) return false;
            if (this.hostedZones != null ? !this.hostedZones.equals(that.hostedZones) : that.hostedZones != null) return false;
            if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
            return this.validationDomains != null ? this.validationDomains.equals(that.validationDomains) : that.validationDomains == null;
        }

        @Override
        public int hashCode() {
            int result = this.hostedZone != null ? this.hostedZone.hashCode() : 0;
            result = 31 * result + (this.hostedZones != null ? this.hostedZones.hashCode() : 0);
            result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
            result = 31 * result + (this.validationDomains != null ? this.validationDomains.hashCode() : 0);
            return result;
        }
    }
}
