package software.amazon.awscdk.services.certificatemanager;

/**
 * Properties for your certificate.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-20T10:00:17.738Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CertificateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Fully-qualified domain name to request a certificate for.
     * 
     * May contain wildcards, such as ``*.domain.com``.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDomainName();

    /**
     * Alternative domain names on your certificate.
     * 
     * Use this to register alternative domain names that represent the same site.
     * 
     * Default: - No additional FQDNs will be included as alternative domain names.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getSubjectAlternativeNames();

    /**
     * What validation domain to use for every requested domain.
     * 
     * Has to be a superdomain of the requested domain.
     * 
     * Default: - Apex domain is used for every domain that's not overridden.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.String> getValidationDomains();

    /**
     * Validation method used to assert domain ownership.
     * 
     * Default: ValidationMethod.EMAIL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.certificatemanager.ValidationMethod getValidationMethod();

    /**
     * @return a {@link Builder} of {@link CertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String domainName;
        private java.util.List<java.lang.String> subjectAlternativeNames;
        private java.util.Map<java.lang.String, java.lang.String> validationDomains;
        private software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod;

        /**
         * Sets the value of DomainName
         * @param domainName Fully-qualified domain name to request a certificate for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of SubjectAlternativeNames
         * @param subjectAlternativeNames Alternative domain names on your certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(java.util.List<java.lang.String> subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        /**
         * Sets the value of ValidationDomains
         * @param validationDomains What validation domain to use for every requested domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationDomains(java.util.Map<java.lang.String, java.lang.String> validationDomains) {
            this.validationDomains = validationDomains;
            return this;
        }

        /**
         * Sets the value of ValidationMethod
         * @param validationMethod Validation method used to assert domain ownership.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationMethod(software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            this.validationMethod = validationMethod;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CertificateProps build() {
            return new Jsii$Proxy(domainName, subjectAlternativeNames, validationDomains, validationMethod);
        }
    }

    /**
     * An implementation for {@link CertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateProps {
        private final java.lang.String domainName;
        private final java.util.List<java.lang.String> subjectAlternativeNames;
        private final java.util.Map<java.lang.String, java.lang.String> validationDomains;
        private final software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.subjectAlternativeNames = this.jsiiGet("subjectAlternativeNames", java.util.List.class);
            this.validationDomains = this.jsiiGet("validationDomains", java.util.Map.class);
            this.validationMethod = this.jsiiGet("validationMethod", software.amazon.awscdk.services.certificatemanager.ValidationMethod.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String domainName, java.util.List<java.lang.String> subjectAlternativeNames, java.util.Map<java.lang.String, java.lang.String> validationDomains, software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
            this.subjectAlternativeNames = subjectAlternativeNames;
            this.validationDomains = validationDomains;
            this.validationMethod = validationMethod;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this.validationDomains;
        }

        @Override
        public software.amazon.awscdk.services.certificatemanager.ValidationMethod getValidationMethod() {
            return this.validationMethod;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getSubjectAlternativeNames() != null) {
                obj.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
            }
            if (this.getValidationDomains() != null) {
                obj.set("validationDomains", om.valueToTree(this.getValidationDomains()));
            }
            if (this.getValidationMethod() != null) {
                obj.set("validationMethod", om.valueToTree(this.getValidationMethod()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CertificateProps.Jsii$Proxy that = (CertificateProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (this.subjectAlternativeNames != null ? !this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames != null) return false;
            if (this.validationDomains != null ? !this.validationDomains.equals(that.validationDomains) : that.validationDomains != null) return false;
            return this.validationMethod != null ? this.validationMethod.equals(that.validationMethod) : that.validationMethod == null;
        }

        @Override
        public int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
            result = 31 * result + (this.validationDomains != null ? this.validationDomains.hashCode() : 0);
            result = 31 * result + (this.validationMethod != null ? this.validationMethod.hashCode() : 0);
            return result;
        }
    }
}
