/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.certificatemanager;

import java.util.List;
import java.util.Map;
import software.amazon.awscdk.services.certificatemanager.CertificateProps;
import software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps;
import software.amazon.awscdk.services.certificatemanager.ValidationMethod;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.route53.IHostedZone;
import software.amazon.jsii.JsiiSerializable;

public interface DnsValidatedCertificateProps
extends JsiiSerializable,
CertificateProps {
    public IHostedZone getHostedZone();

    public IRole getCustomResourceRole();

    public String getRegion();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IHostedZone hostedZone;
        private IRole customResourceRole;
        private String region;
        private String domainName;
        private List<String> subjectAlternativeNames;
        private Map<String, String> validationDomains;
        private ValidationMethod validationMethod;

        public Builder hostedZone(IHostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public Builder customResourceRole(IRole customResourceRole) {
            this.customResourceRole = customResourceRole;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder subjectAlternativeNames(List<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        public Builder validationDomains(Map<String, String> validationDomains) {
            this.validationDomains = validationDomains;
            return this;
        }

        public Builder validationMethod(ValidationMethod validationMethod) {
            this.validationMethod = validationMethod;
            return this;
        }

        public DnsValidatedCertificateProps build() {
            return new Jsii.Proxy(this.hostedZone, this.customResourceRole, this.region, this.domainName, this.subjectAlternativeNames, this.validationDomains, this.validationMethod, null);
        }
    }
}

