/**
 * <h1>AWS Certificate Manager Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * AWS Certificate Manager (ACM) handles the complexity of creating, storing, and renewing public and private SSL/TLS X.509 certificates and keys that
 * protect your AWS websites and applications. ACM certificates can secure singular domain names, multiple specific domain names, wildcard domains, or
 * combinations of these. ACM wildcard certificates can protect an unlimited number of subdomains.
 * <p>
 * This package provides Constructs for provisioning and referencing ACM certificates which can be used with CloudFront and ELB.
 * <p>
 * After requesting a certificate, you will need to prove that you own the
 * domain in question before the certificate will be granted. The CloudFormation
 * deployment will wait until this verification process has been completed.
 * <p>
 * Because of this wait time, when using manual validation methods, it's better
 * to provision your certificates either in a separate stack from your main
 * service, or provision them manually and import them into your CDK application.
 * <p>
 * <strong>Note:</strong> There is a limit on total number of ACM certificates that can be requested on an account and region within a year.
 * The default limit is 2000, but this limit may be (much) lower on new AWS accounts.
 * See https://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html for more information.
 * <p>
 * <h2>DNS validation</h2>
 * <p>
 * DNS validation is the preferred method to validate domain ownership, as it has a number of advantages over email validation.
 * See also <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">Validate with DNS</a>
 * in the AWS Certificate Manager User Guide.
 * <p>
 * If Amazon Route 53 is your DNS provider for the requested domain, the DNS record can be
 * created automatically:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.route53.*;
 * 
 * 
 * HostedZone myHostedZone = new HostedZone(this, "HostedZone", new HostedZoneProps()
 *         .zoneName("example.com"));
 * new Certificate(this, "Certificate", new CertificateProps()
 *         .domainName("hello.example.com")
 *         .validation(acm.CertificateValidation.fromDns(myHostedZone)));
 * </pre></blockquote>
 * <p>
 * If Route 53 is not your DNS provider, the DNS records must be added manually and the stack will not complete
 * creating until the records are added.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Certificate.Builder.create(this, "Certificate")
 *         .domainName("hello.example.com")
 *         .validation(acm.CertificateValidation.fromDns())
 *         .build();
 * </pre></blockquote>
 * <p>
 * When working with multiple domains, use the <code>CertificateValidation.fromDnsMultiZone()</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object exampleCom = HostedZone.Builder.create(this, "ExampleCom")
 *         .zoneName("example.com")
 *         .build();
 * Object exampleNet = HostedZone.Builder.create(this, "ExampleNet")
 *         .zoneName("example.net")
 *         .build();
 * 
 * Object cert = Certificate.Builder.create(this, "Certificate")
 *         .domainName("test.example.com")
 *         .subjectAlternativeNames(asList("cool.example.com", "test.example.net"))
 *         .validation(acm.CertificateValidation.fromDnsMultiZone(Map.of(
 *                 "test.example.com", exampleCom,
 *                 "cool.example.com", exampleCom,
 *                 "test.example.net", exampleNet)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Email validation</h2>
 * <p>
 * Email-validated certificates (the default) are validated by receiving an
 * email on one of a number of predefined domains and following the instructions
 * in the email.
 * <p>
 * See <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">Validate with Email</a>
 * in the AWS Certificate Manager User Guide.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Certificate.Builder.create(this, "Certificate")
 *         .domainName("hello.example.com")
 *         .validation(acm.CertificateValidation.fromEmail())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Cross-region Certificates</h2>
 * <p>
 * ACM certificates that are used with CloudFront -- or higher-level constructs which rely on CloudFront -- must be in the <code>us-east-1</code> region.
 * The <code>DnsValidatedCertificate</code> construct exists to facilitate creating these certificates cross-region. This resource can only be used with
 * Route53-based DNS validation.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * DnsValidatedCertificate.Builder.create(this, "CrossRegionCertificate")
 *         .domainName("hello.example.com")
 *         .hostedZone(myHostedZone)
 *         .region("us-east-1")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Importing</h2>
 * <p>
 * If you want to import an existing certificate, you can do so from its ARN:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * String arn = "arn:aws:...";
 * Object certificate = Certificate.fromCertificateArn(this, "Certificate", arn);
 * </pre></blockquote>
 * <p>
 * <h2>Sharing between Stacks</h2>
 * <p>
 * To share the certificate between stacks in the same CDK application, simply
 * pass the <code>Certificate</code> object between the stacks.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.certificatemanager;
