package software.amazon.awscdk.services.cloud9.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloud9.$Module.class, fqn = "@aws-cdk/aws-cloud9.cloudformation.EnvironmentEC2Resource")
public class EnvironmentEC2Resource extends software.amazon.awscdk.Resource {
    protected EnvironmentEC2Resource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloud9.cloudformation.EnvironmentEC2Resource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::Cloud9::EnvironmentEC2``.
     * @param parent the ``cdk.Construct`` this ``EnvironmentEC2Resource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``EnvironmentEC2Resource``
     */
    public EnvironmentEC2Resource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.cloud9.cloudformation.EnvironmentEC2ResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute Arn
     */
    public software.amazon.awscdk.services.cloud9.EnvironmentEC2Arn getEnvironmentEc2Arn() {
        return this.jsiiGet("environmentEc2Arn", software.amazon.awscdk.services.cloud9.EnvironmentEC2Arn.class);
    }
    /**
     * @cloudformation_attribute Name
     */
    public software.amazon.awscdk.services.cloud9.EnvironmentEC2Name getEnvironmentEc2Name() {
        return this.jsiiGet("environmentEc2Name", software.amazon.awscdk.services.cloud9.EnvironmentEC2Name.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html
     */
    public static interface RepositoryProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``EnvironmentEC2Resource.RepositoryProperty.PathComponent``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
         */
        java.lang.Object getPathComponent();
        /**
         * ``EnvironmentEC2Resource.RepositoryProperty.PathComponent``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
         */
        void setPathComponent(final java.lang.String value);
        /**
         * ``EnvironmentEC2Resource.RepositoryProperty.PathComponent``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
         */
        void setPathComponent(final software.amazon.awscdk.Token value);
        /**
         * ``EnvironmentEC2Resource.RepositoryProperty.RepositoryUrl``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
         */
        java.lang.Object getRepositoryUrl();
        /**
         * ``EnvironmentEC2Resource.RepositoryProperty.RepositoryUrl``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
         */
        void setRepositoryUrl(final java.lang.String value);
        /**
         * ``EnvironmentEC2Resource.RepositoryProperty.RepositoryUrl``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
         */
        void setRepositoryUrl(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link RepositoryProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``EnvironmentEC2Resource.RepositoryProperty.PathComponent``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
             */
            public RepositoryUrlStep withPathComponent(final java.lang.String value) {
                return new FullBuilder().withPathComponent(value);
            }
            /**
             * ``EnvironmentEC2Resource.RepositoryProperty.PathComponent``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
             */
            public RepositoryUrlStep withPathComponent(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withPathComponent(value);
            }

            public interface RepositoryUrlStep {
                /**
                 * ``EnvironmentEC2Resource.RepositoryProperty.RepositoryUrl``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
                 */
                Build withRepositoryUrl(final java.lang.String value);
                /**
                 * ``EnvironmentEC2Resource.RepositoryProperty.RepositoryUrl``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
                 */
                Build withRepositoryUrl(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link RepositoryProperty} object, initialized with the values set on this builder.
                 */
                RepositoryProperty build();
            }

            final class FullBuilder implements RepositoryUrlStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``EnvironmentEC2Resource.RepositoryProperty.PathComponent``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
                 */
                public RepositoryUrlStep withPathComponent(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "RepositoryProperty#pathComponent is required");
                    this.instance._pathComponent = value;
                    return this;
                }
                /**
                 * ``EnvironmentEC2Resource.RepositoryProperty.PathComponent``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
                 */
                public RepositoryUrlStep withPathComponent(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "RepositoryProperty#pathComponent is required");
                    this.instance._pathComponent = value;
                    return this;
                }
                /**
                 * ``EnvironmentEC2Resource.RepositoryProperty.RepositoryUrl``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
                 */
                public Build withRepositoryUrl(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "RepositoryProperty#repositoryUrl is required");
                    this.instance._repositoryUrl = value;
                    return this;
                }
                /**
                 * ``EnvironmentEC2Resource.RepositoryProperty.RepositoryUrl``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
                 */
                public Build withRepositoryUrl(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "RepositoryProperty#repositoryUrl is required");
                    this.instance._repositoryUrl = value;
                    return this;
                }
                public RepositoryProperty build() {
                    RepositoryProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link RepositoryProperty}.
         */
        final class Jsii$Pojo implements RepositoryProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _pathComponent;

            public java.lang.Object getPathComponent() {
                return this._pathComponent;
            }
            public void setPathComponent(final java.lang.String value) {
                this._pathComponent = value;
            }
            public void setPathComponent(final software.amazon.awscdk.Token value) {
                this._pathComponent = value;
            }

            protected java.lang.Object _repositoryUrl;

            public java.lang.Object getRepositoryUrl() {
                return this._repositoryUrl;
            }
            public void setRepositoryUrl(final java.lang.String value) {
                this._repositoryUrl = value;
            }
            public void setRepositoryUrl(final software.amazon.awscdk.Token value) {
                this._repositoryUrl = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloud9.cloudformation.EnvironmentEC2Resource.RepositoryProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``EnvironmentEC2Resource.RepositoryProperty.PathComponent``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
             */
            public java.lang.Object getPathComponent() {
                return this.jsiiGet("pathComponent", java.lang.Object.class);
            }
            /**
             * ``EnvironmentEC2Resource.RepositoryProperty.PathComponent``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
             */
            public void setPathComponent(final java.lang.String value) {
                this.jsiiSet("pathComponent", java.util.Objects.requireNonNull(value, "pathComponent is required"));
            }
            /**
             * ``EnvironmentEC2Resource.RepositoryProperty.PathComponent``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
             */
            public void setPathComponent(final software.amazon.awscdk.Token value) {
                this.jsiiSet("pathComponent", java.util.Objects.requireNonNull(value, "pathComponent is required"));
            }
            /**
             * ``EnvironmentEC2Resource.RepositoryProperty.RepositoryUrl``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
             */
            public java.lang.Object getRepositoryUrl() {
                return this.jsiiGet("repositoryUrl", java.lang.Object.class);
            }
            /**
             * ``EnvironmentEC2Resource.RepositoryProperty.RepositoryUrl``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
             */
            public void setRepositoryUrl(final java.lang.String value) {
                this.jsiiSet("repositoryUrl", java.util.Objects.requireNonNull(value, "repositoryUrl is required"));
            }
            /**
             * ``EnvironmentEC2Resource.RepositoryProperty.RepositoryUrl``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
             */
            public void setRepositoryUrl(final software.amazon.awscdk.Token value) {
                this.jsiiSet("repositoryUrl", java.util.Objects.requireNonNull(value, "repositoryUrl is required"));
            }
        }
    }
}
