package software.amazon.awscdk.services.cloud9;

/**
 * (experimental) Properties for Ec2Environment.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.39.0 (build 8af72c2)", date = "2021-10-14T05:49:02.483Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloud9.$Module.class, fqn = "@aws-cdk/aws-cloud9.Ec2EnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(Ec2EnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Ec2EnvironmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The VPC that AWS Cloud9 will use to communicate with the Amazon Elastic Compute Cloud (Amazon EC2) instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * (experimental) The AWS CodeCommit repository to be cloned.
     * <p>
     * Default: - do not clone any repository
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloud9.CloneRepository> getClonedRepositories() {
        return null;
    }

    /**
     * (experimental) Description of the environment.
     * <p>
     * Default: - no description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) Name of the environment.
     * <p>
     * Default: - automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getEc2EnvironmentName() {
        return null;
    }

    /**
     * (experimental) The type of instance to connect to the environment.
     * <p>
     * Default: - t2.micro
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return null;
    }

    /**
     * (experimental) The subnetSelection of the VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
     * <p>
     * Default: - all public subnets of the VPC are selected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Ec2EnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Ec2EnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<Ec2EnvironmentProps> {
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.util.List<software.amazon.awscdk.services.cloud9.CloneRepository> clonedRepositories;
        private java.lang.String description;
        private java.lang.String ec2EnvironmentName;
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;

        /**
         * Sets the value of {@link Ec2EnvironmentProps#getVpc}
         * @param vpc The VPC that AWS Cloud9 will use to communicate with the Amazon Elastic Compute Cloud (Amazon EC2) instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link Ec2EnvironmentProps#getClonedRepositories}
         * @param clonedRepositories The AWS CodeCommit repository to be cloned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder clonedRepositories(java.util.List<? extends software.amazon.awscdk.services.cloud9.CloneRepository> clonedRepositories) {
            this.clonedRepositories = (java.util.List<software.amazon.awscdk.services.cloud9.CloneRepository>)clonedRepositories;
            return this;
        }

        /**
         * Sets the value of {@link Ec2EnvironmentProps#getDescription}
         * @param description Description of the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link Ec2EnvironmentProps#getEc2EnvironmentName}
         * @param ec2EnvironmentName Name of the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ec2EnvironmentName(java.lang.String ec2EnvironmentName) {
            this.ec2EnvironmentName = ec2EnvironmentName;
            return this;
        }

        /**
         * Sets the value of {@link Ec2EnvironmentProps#getInstanceType}
         * @param instanceType The type of instance to connect to the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link Ec2EnvironmentProps#getSubnetSelection}
         * @param subnetSelection The subnetSelection of the VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Ec2EnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public Ec2EnvironmentProps build() {
            return new Jsii$Proxy(vpc, clonedRepositories, description, ec2EnvironmentName, instanceType, subnetSelection);
        }
    }

    /**
     * An implementation for {@link Ec2EnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ec2EnvironmentProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.util.List<software.amazon.awscdk.services.cloud9.CloneRepository> clonedRepositories;
        private final java.lang.String description;
        private final java.lang.String ec2EnvironmentName;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.clonedRepositories = software.amazon.jsii.Kernel.get(this, "clonedRepositories", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloud9.CloneRepository.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ec2EnvironmentName = software.amazon.jsii.Kernel.get(this, "ec2EnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.ec2.IVpc vpc, final java.util.List<? extends software.amazon.awscdk.services.cloud9.CloneRepository> clonedRepositories, final java.lang.String description, final java.lang.String ec2EnvironmentName, final software.amazon.awscdk.services.ec2.InstanceType instanceType, final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.clonedRepositories = (java.util.List<software.amazon.awscdk.services.cloud9.CloneRepository>)clonedRepositories;
            this.description = description;
            this.ec2EnvironmentName = ec2EnvironmentName;
            this.instanceType = instanceType;
            this.subnetSelection = subnetSelection;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloud9.CloneRepository> getClonedRepositories() {
            return this.clonedRepositories;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEc2EnvironmentName() {
            return this.ec2EnvironmentName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getClonedRepositories() != null) {
                data.set("clonedRepositories", om.valueToTree(this.getClonedRepositories()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEc2EnvironmentName() != null) {
                data.set("ec2EnvironmentName", om.valueToTree(this.getEc2EnvironmentName()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloud9.Ec2EnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Ec2EnvironmentProps.Jsii$Proxy that = (Ec2EnvironmentProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (this.clonedRepositories != null ? !this.clonedRepositories.equals(that.clonedRepositories) : that.clonedRepositories != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.ec2EnvironmentName != null ? !this.ec2EnvironmentName.equals(that.ec2EnvironmentName) : that.ec2EnvironmentName != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            return this.subnetSelection != null ? this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.clonedRepositories != null ? this.clonedRepositories.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.ec2EnvironmentName != null ? this.ec2EnvironmentName.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            return result;
        }
    }
}
