package software.amazon.awscdk.services.cloud9;

/**
 * Properties for defining a `AWS::Cloud9::EnvironmentEC2`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-28T12:14:20.145Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnEnvironmentEC2Props extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Cloud9::EnvironmentEC2.InstanceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceType();

    /**
     * `AWS::Cloud9::EnvironmentEC2.AutomaticStopTimeMinutes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-automaticstoptimeminutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getAutomaticStopTimeMinutes();

    /**
     * `AWS::Cloud9::EnvironmentEC2.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDescription();

    /**
     * `AWS::Cloud9::EnvironmentEC2.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getName();

    /**
     * `AWS::Cloud9::EnvironmentEC2.OwnerArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-ownerarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getOwnerArn();

    /**
     * `AWS::Cloud9::EnvironmentEC2.Repositories`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-repositories
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getRepositories();

    /**
     * `AWS::Cloud9::EnvironmentEC2.SubnetId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-subnetid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getSubnetId();

    /**
     * @return a {@link Builder} of {@link CfnEnvironmentEC2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnvironmentEC2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String instanceType;
        private java.lang.Number automaticStopTimeMinutes;
        private java.lang.String description;
        private java.lang.String name;
        private java.lang.String ownerArn;
        private java.lang.Object repositories;
        private java.lang.String subnetId;

        /**
         * Sets the value of InstanceType
         * @param instanceType `AWS::Cloud9::EnvironmentEC2.InstanceType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of AutomaticStopTimeMinutes
         * @param automaticStopTimeMinutes `AWS::Cloud9::EnvironmentEC2.AutomaticStopTimeMinutes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder automaticStopTimeMinutes(java.lang.Number automaticStopTimeMinutes) {
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::Cloud9::EnvironmentEC2.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of Name
         * @param name `AWS::Cloud9::EnvironmentEC2.Name`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of OwnerArn
         * @param ownerArn `AWS::Cloud9::EnvironmentEC2.OwnerArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ownerArn(java.lang.String ownerArn) {
            this.ownerArn = ownerArn;
            return this;
        }

        /**
         * Sets the value of Repositories
         * @param repositories `AWS::Cloud9::EnvironmentEC2.Repositories`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder repositories(software.amazon.awscdk.core.IResolvable repositories) {
            this.repositories = repositories;
            return this;
        }

        /**
         * Sets the value of Repositories
         * @param repositories `AWS::Cloud9::EnvironmentEC2.Repositories`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder repositories(java.util.List<java.lang.Object> repositories) {
            this.repositories = repositories;
            return this;
        }

        /**
         * Sets the value of SubnetId
         * @param subnetId `AWS::Cloud9::EnvironmentEC2.SubnetId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnvironmentEC2Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnEnvironmentEC2Props build() {
            return new Jsii$Proxy(instanceType, automaticStopTimeMinutes, description, name, ownerArn, repositories, subnetId);
        }
    }

    /**
     * An implementation for {@link CfnEnvironmentEC2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnvironmentEC2Props {
        private final java.lang.String instanceType;
        private final java.lang.Number automaticStopTimeMinutes;
        private final java.lang.String description;
        private final java.lang.String name;
        private final java.lang.String ownerArn;
        private final java.lang.Object repositories;
        private final java.lang.String subnetId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
            this.automaticStopTimeMinutes = this.jsiiGet("automaticStopTimeMinutes", java.lang.Number.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.ownerArn = this.jsiiGet("ownerArn", java.lang.String.class);
            this.repositories = this.jsiiGet("repositories", java.lang.Object.class);
            this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String instanceType, java.lang.Number automaticStopTimeMinutes, java.lang.String description, java.lang.String name, java.lang.String ownerArn, java.lang.Object repositories, java.lang.String subnetId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
            this.description = description;
            this.name = name;
            this.ownerArn = ownerArn;
            this.repositories = repositories;
            this.subnetId = subnetId;
        }

        @Override
        public java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public java.lang.Number getAutomaticStopTimeMinutes() {
            return this.automaticStopTimeMinutes;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.lang.String getOwnerArn() {
            return this.ownerArn;
        }

        @Override
        public java.lang.Object getRepositories() {
            return this.repositories;
        }

        @Override
        public java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getAutomaticStopTimeMinutes() != null) {
                obj.set("automaticStopTimeMinutes", om.valueToTree(this.getAutomaticStopTimeMinutes()));
            }
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                obj.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOwnerArn() != null) {
                obj.set("ownerArn", om.valueToTree(this.getOwnerArn()));
            }
            if (this.getRepositories() != null) {
                obj.set("repositories", om.valueToTree(this.getRepositories()));
            }
            if (this.getSubnetId() != null) {
                obj.set("subnetId", om.valueToTree(this.getSubnetId()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnvironmentEC2Props.Jsii$Proxy that = (CfnEnvironmentEC2Props.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (this.automaticStopTimeMinutes != null ? !this.automaticStopTimeMinutes.equals(that.automaticStopTimeMinutes) : that.automaticStopTimeMinutes != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.ownerArn != null ? !this.ownerArn.equals(that.ownerArn) : that.ownerArn != null) return false;
            if (this.repositories != null ? !this.repositories.equals(that.repositories) : that.repositories != null) return false;
            return this.subnetId != null ? this.subnetId.equals(that.subnetId) : that.subnetId == null;
        }

        @Override
        public int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.automaticStopTimeMinutes != null ? this.automaticStopTimeMinutes.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.ownerArn != null ? this.ownerArn.hashCode() : 0);
            result = 31 * result + (this.repositories != null ? this.repositories.hashCode() : 0);
            result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
            return result;
        }
    }
}
