package software.amazon.awscdk.services.cloud9;

/**
 * (experimental) A Cloud9 Environment with Amazon EC2.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // create a cloud9 ec2 environment in a new VPC
 * Vpc vpc = Vpc.Builder.create(this, "VPC").maxAzs(3).build();
 * Ec2Environment.Builder.create(this, "Cloud9Env").vpc(vpc).build();
 * // or create the cloud9 environment in the default VPC with specific instanceType
 * IVpc defaultVpc = Vpc.fromLookup(this, "DefaultVPC", VpcLookupOptions.builder().isDefault(true).build());
 * Ec2Environment.Builder.create(this, "Cloud9Env2")
 *         .vpc(defaultVpc)
 *         .instanceType(new InstanceType("t3.large"))
 *         .build();
 * // or specify in a different subnetSelection
 * Ec2Environment c9env = Ec2Environment.Builder.create(this, "Cloud9Env3")
 *         .vpc(vpc)
 *         .subnetSelection(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PRIVATE_WITH_NAT)
 *                 .build())
 *         .build();
 * // print the Cloud9 IDE URL in the output
 * // print the Cloud9 IDE URL in the output
 * CfnOutput.Builder.create(this, "URL").value(c9env.getIdeUrl()).build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T02:14:10.217Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloud9.$Module.class, fqn = "@aws-cdk/aws-cloud9.Ec2Environment")
public class Ec2Environment extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.cloud9.IEc2Environment {

    protected Ec2Environment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Ec2Environment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Ec2Environment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloud9.Ec2EnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) import from EnvironmentEc2Name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param ec2EnvironmentName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloud9.IEc2Environment fromEc2EnvironmentName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String ec2EnvironmentName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloud9.Ec2Environment.class, "fromEc2EnvironmentName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloud9.IEc2Environment.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(ec2EnvironmentName, "ec2EnvironmentName is required") });
    }

    /**
     * (experimental) The environment ARN of this Cloud9 environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getEc2EnvironmentArn() {
        return software.amazon.jsii.Kernel.get(this, "ec2EnvironmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The environment name of this Cloud9 environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getEc2EnvironmentName() {
        return software.amazon.jsii.Kernel.get(this, "ec2EnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The environment ID of this Cloud9 environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentId() {
        return software.amazon.jsii.Kernel.get(this, "environmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The complete IDE URL of this Cloud9 environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getIdeUrl() {
        return software.amazon.jsii.Kernel.get(this, "ideUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) VPC ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cloud9.Ec2Environment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloud9.Ec2Environment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloud9.Ec2EnvironmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloud9.Ec2EnvironmentProps.Builder();
        }

        /**
         * (experimental) The VPC that AWS Cloud9 will use to communicate with the Amazon Elastic Compute Cloud (Amazon EC2) instance.
         * <p>
         * @return {@code this}
         * @param vpc The VPC that AWS Cloud9 will use to communicate with the Amazon Elastic Compute Cloud (Amazon EC2) instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * (experimental) The AWS CodeCommit repository to be cloned.
         * <p>
         * Default: - do not clone any repository
         * <p>
         * @return {@code this}
         * @param clonedRepositories The AWS CodeCommit repository to be cloned. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clonedRepositories(final java.util.List<? extends software.amazon.awscdk.services.cloud9.CloneRepository> clonedRepositories) {
            this.props.clonedRepositories(clonedRepositories);
            return this;
        }

        /**
         * (experimental) The connection type used for connecting to an Amazon EC2 environment.
         * <p>
         * Valid values are: CONNECT_SSH (default) and CONNECT_SSM (connected through AWS Systems Manager)
         * <p>
         * Default: - CONNECT_SSH
         * <p>
         * @return {@code this}
         * @param connectionType The connection type used for connecting to an Amazon EC2 environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionType(final software.amazon.awscdk.services.cloud9.ConnectionType connectionType) {
            this.props.connectionType(connectionType);
            return this;
        }

        /**
         * (experimental) Description of the environment.
         * <p>
         * Default: - no description
         * <p>
         * @return {@code this}
         * @param description Description of the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) Name of the environment.
         * <p>
         * Default: - automatically generated name
         * <p>
         * @return {@code this}
         * @param ec2EnvironmentName Name of the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ec2EnvironmentName(final java.lang.String ec2EnvironmentName) {
            this.props.ec2EnvironmentName(ec2EnvironmentName);
            return this;
        }

        /**
         * (experimental) The type of instance to connect to the environment.
         * <p>
         * Default: - t2.micro
         * <p>
         * @return {@code this}
         * @param instanceType The type of instance to connect to the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * (experimental) The subnetSelection of the VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
         * <p>
         * Default: - all public subnets of the VPC are selected.
         * <p>
         * @return {@code this}
         * @param subnetSelection The subnetSelection of the VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloud9.Ec2Environment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cloud9.Ec2Environment build() {
            return new software.amazon.awscdk.services.cloud9.Ec2Environment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
