/**
 * <h1>AWS Cloud9 Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="End-of-Support" src="https://img.shields.io/badge/End--of--Support-critical.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * AWS CDK v1 has reached End-of-Support on 2023-06-01.
 * This package is no longer being updated, and users should migrate to AWS CDK v2.
 * <p>
 * For more information on how to migrate, see the <a href="https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html"><em>Migrating to AWS CDK v2</em> guide</a>.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * AWS Cloud9 is a cloud-based integrated development environment (IDE) that lets you write, run, and debug your code with just a
 * browser. It includes a code editor, debugger, and terminal. Cloud9 comes prepackaged with essential tools for popular
 * programming languages, including JavaScript, Python, PHP, and more, so you don’t need to install files or configure your
 * development machine to start new projects. Since your Cloud9 IDE is cloud-based, you can work on your projects from your
 * office, home, or anywhere using an internet-connected machine. Cloud9 also provides a seamless experience for developing
 * serverless applications enabling you to easily define resources, debug, and switch between local and remote execution of
 * serverless applications. With Cloud9, you can quickly share your development environment with your team, enabling you to pair
 * program and track each other's inputs in real time.
 * <p>
 * <h2>Creating EC2 Environment</h2>
 * <p>
 * EC2 Environments are defined with <code>Ec2Environment</code>. To create an EC2 environment in the private subnet, specify
 * <code>subnetSelection</code> with private <code>subnetType</code>.
 * <p>
 * <blockquote><pre>
 * // create a cloud9 ec2 environment in a new VPC
 * Vpc vpc = Vpc.Builder.create(this, "VPC").maxAzs(3).build();
 * Ec2Environment.Builder.create(this, "Cloud9Env").vpc(vpc).build();
 * 
 * // or create the cloud9 environment in the default VPC with specific instanceType
 * IVpc defaultVpc = Vpc.fromLookup(this, "DefaultVPC", VpcLookupOptions.builder().isDefault(true).build());
 * Ec2Environment.Builder.create(this, "Cloud9Env2")
 *         .vpc(defaultVpc)
 *         .instanceType(new InstanceType("t3.large"))
 *         .build();
 * 
 * // or specify in a different subnetSelection
 * Ec2Environment c9env = Ec2Environment.Builder.create(this, "Cloud9Env3")
 *         .vpc(vpc)
 *         .subnetSelection(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PRIVATE_WITH_NAT)
 *                 .build())
 *         .build();
 * 
 * // print the Cloud9 IDE URL in the output
 * // print the Cloud9 IDE URL in the output
 * CfnOutput.Builder.create(this, "URL").value(c9env.getIdeUrl()).build();
 * </pre></blockquote>
 * <p>
 * <h2>Cloning Repositories</h2>
 * <p>
 * Use <code>clonedRepositories</code> to clone one or multiple AWS Codecommit repositories into the environment:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codecommit.*;
 * 
 * // create a new Cloud9 environment and clone the two repositories
 * Vpc vpc;
 * 
 * 
 * // create a codecommit repository to clone into the cloud9 environment
 * Repository repoNew = Repository.Builder.create(this, "RepoNew")
 *         .repositoryName("new-repo")
 *         .build();
 * 
 * // import an existing codecommit repository to clone into the cloud9 environment
 * IRepository repoExisting = Repository.fromRepositoryName(this, "RepoExisting", "existing-repo");
 * Ec2Environment.Builder.create(this, "C9Env")
 *         .vpc(vpc)
 *         .clonedRepositories(List.of(CloneRepository.fromCodeCommit(repoNew, "/src/new-repo"), CloneRepository.fromCodeCommit(repoExisting, "/src/existing-repo")))
 *         .build();
 * </pre></blockquote>
 *
 * Deprecated: AWS CDK v1 has reached End-of-Support on 2023-06-01.
This package is no longer being updated, and users should migrate to AWS CDK v2.

For more information on how to migrate, see https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@Deprecated
package software.amazon.awscdk.services.cloud9;
