/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloud9;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloud9.$Module;
import software.amazon.awscdk.services.cloud9.CloneRepository;
import software.amazon.awscdk.services.cloud9.Ec2EnvironmentProps;
import software.amazon.awscdk.services.cloud9.IEc2Environment;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloud9.Ec2Environment")
public class Ec2Environment
extends Resource
implements IEc2Environment {
    protected Ec2Environment(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Ec2Environment(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Ec2Environment(@NotNull Construct scope, @NotNull String id, @NotNull Ec2EnvironmentProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IEc2Environment fromEc2EnvironmentName(@NotNull Construct scope, @NotNull String id, @NotNull String ec2EnvironmentName) {
        return (IEc2Environment)JsiiObject.jsiiStaticCall(Ec2Environment.class, (String)"fromEc2EnvironmentName", IEc2Environment.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(ec2EnvironmentName, "ec2EnvironmentName is required")});
    }

    @Override
    @NotNull
    public String getEc2EnvironmentArn() {
        return (String)this.jsiiGet("ec2EnvironmentArn", String.class);
    }

    @Override
    @NotNull
    public String getEc2EnvironmentName() {
        return (String)this.jsiiGet("ec2EnvironmentName", String.class);
    }

    @NotNull
    public String getEnvironmentId() {
        return (String)this.jsiiGet("environmentId", String.class);
    }

    @NotNull
    public String getIdeUrl() {
        return (String)this.jsiiGet("ideUrl", String.class);
    }

    @NotNull
    public IVpc getVpc() {
        return (IVpc)this.jsiiGet("vpc", IVpc.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Ec2Environment> {
        private final Construct scope;
        private final String id;
        private final Ec2EnvironmentProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new Ec2EnvironmentProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder clonedRepositories(List<? extends CloneRepository> clonedRepositories) {
            this.props.clonedRepositories(clonedRepositories);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder ec2EnvironmentName(String ec2EnvironmentName) {
            this.props.ec2EnvironmentName(ec2EnvironmentName);
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public Ec2Environment build() {
            return new Ec2Environment(this.scope, this.id, this.props.build());
        }
    }
}

