package software.amazon.awscdk.services.cloudfront;

/**
 * The type of events that a CloudFront function can be invoked in response to.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket s3Bucket;
 * // Add a cloudfront Function to a Distribution
 * Function cfFunction = Function.Builder.create(this, "Function")
 *         .code(FunctionCode.fromInline("function handler(event) { return event.request }"))
 *         .build();
 * Distribution.Builder.create(this, "distro")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new S3Origin(s3Bucket))
 *                 .functionAssociations(List.of(FunctionAssociation.builder()
 *                         .function(cfFunction)
 *                         .eventType(FunctionEventType.VIEWER_REQUEST)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:44.325Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.FunctionEventType")
public enum FunctionEventType {
    /**
     * The viewer-request specifies the incoming request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VIEWER_REQUEST,
    /**
     * The viewer-response specifies the outgoing response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VIEWER_RESPONSE,
}
