package software.amazon.awscdk.services.cloudfront;

/**
 * Properties of CloudFront OriginAccessIdentity.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * OriginAccessIdentityProps originAccessIdentityProps = OriginAccessIdentityProps.builder()
 *         .comment("comment")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:44.340Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.OriginAccessIdentityProps")
@software.amazon.jsii.Jsii.Proxy(OriginAccessIdentityProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OriginAccessIdentityProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Any comments you want to include about the origin access identity.
     * <p>
     * Default: "Allows CloudFront to reach the bucket"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OriginAccessIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OriginAccessIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OriginAccessIdentityProps> {
        java.lang.String comment;

        /**
         * Sets the value of {@link OriginAccessIdentityProps#getComment}
         * @param comment Any comments you want to include about the origin access identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OriginAccessIdentityProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OriginAccessIdentityProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OriginAccessIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginAccessIdentityProps {
        private final java.lang.String comment;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.comment = builder.comment;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.OriginAccessIdentityProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OriginAccessIdentityProps.Jsii$Proxy that = (OriginAccessIdentityProps.Jsii$Proxy) o;

            return this.comment != null ? this.comment.equals(that.comment) : that.comment == null;
        }

        @Override
        public final int hashCode() {
            int result = this.comment != null ? this.comment.hashCode() : 0;
            return result;
        }
    }
}
