/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloudfront.$Module;
import software.amazon.awscdk.services.cloudfront.CacheCookieBehavior;
import software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior;
import software.amazon.awscdk.services.cloudfront.CachePolicyProps;
import software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior;
import software.amazon.awscdk.services.cloudfront.ICachePolicy;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CachePolicy")
public class CachePolicy
extends Resource
implements ICachePolicy {
    public static final ICachePolicy AMPLIFY = (ICachePolicy)JsiiObject.jsiiStaticGet(CachePolicy.class, (String)"AMPLIFY", (NativeType)NativeType.forClass(ICachePolicy.class));
    public static final ICachePolicy CACHING_DISABLED = (ICachePolicy)JsiiObject.jsiiStaticGet(CachePolicy.class, (String)"CACHING_DISABLED", (NativeType)NativeType.forClass(ICachePolicy.class));
    public static final ICachePolicy CACHING_OPTIMIZED = (ICachePolicy)JsiiObject.jsiiStaticGet(CachePolicy.class, (String)"CACHING_OPTIMIZED", (NativeType)NativeType.forClass(ICachePolicy.class));
    public static final ICachePolicy CACHING_OPTIMIZED_FOR_UNCOMPRESSED_OBJECTS = (ICachePolicy)JsiiObject.jsiiStaticGet(CachePolicy.class, (String)"CACHING_OPTIMIZED_FOR_UNCOMPRESSED_OBJECTS", (NativeType)NativeType.forClass(ICachePolicy.class));
    public static final ICachePolicy ELEMENTAL_MEDIA_PACKAGE = (ICachePolicy)JsiiObject.jsiiStaticGet(CachePolicy.class, (String)"ELEMENTAL_MEDIA_PACKAGE", (NativeType)NativeType.forClass(ICachePolicy.class));

    protected CachePolicy(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CachePolicy(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CachePolicy(@NotNull Construct scope, @NotNull String id, @Nullable CachePolicyProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CachePolicy(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static ICachePolicy fromCachePolicyId(@NotNull Construct scope, @NotNull String id, @NotNull String cachePolicyId) {
        return (ICachePolicy)JsiiObject.jsiiStaticCall(CachePolicy.class, (String)"fromCachePolicyId", (NativeType)NativeType.forClass(ICachePolicy.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(cachePolicyId, "cachePolicyId is required")});
    }

    @Override
    @NotNull
    public String getCachePolicyId() {
        return (String)Kernel.get((Object)this, (String)"cachePolicyId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CachePolicy> {
        private final Construct scope;
        private final String id;
        private CachePolicyProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder cachePolicyName(String cachePolicyName) {
            this.props().cachePolicyName(cachePolicyName);
            return this;
        }

        public Builder comment(String comment) {
            this.props().comment(comment);
            return this;
        }

        public Builder cookieBehavior(CacheCookieBehavior cookieBehavior) {
            this.props().cookieBehavior(cookieBehavior);
            return this;
        }

        public Builder defaultTtl(Duration defaultTtl) {
            this.props().defaultTtl(defaultTtl);
            return this;
        }

        public Builder enableAcceptEncodingBrotli(Boolean enableAcceptEncodingBrotli) {
            this.props().enableAcceptEncodingBrotli(enableAcceptEncodingBrotli);
            return this;
        }

        public Builder enableAcceptEncodingGzip(Boolean enableAcceptEncodingGzip) {
            this.props().enableAcceptEncodingGzip(enableAcceptEncodingGzip);
            return this;
        }

        public Builder headerBehavior(CacheHeaderBehavior headerBehavior) {
            this.props().headerBehavior(headerBehavior);
            return this;
        }

        public Builder maxTtl(Duration maxTtl) {
            this.props().maxTtl(maxTtl);
            return this;
        }

        public Builder minTtl(Duration minTtl) {
            this.props().minTtl(minTtl);
            return this;
        }

        public Builder queryStringBehavior(CacheQueryStringBehavior queryStringBehavior) {
            this.props().queryStringBehavior(queryStringBehavior);
            return this;
        }

        public CachePolicy build() {
            return new CachePolicy(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CachePolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new CachePolicyProps.Builder();
            }
            return this.props;
        }
    }
}

