package software.amazon.awscdk.services.cloudfront;

/**
 * A CloudFront behavior wrapper.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:46:52.396Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.Behavior")
@software.amazon.jsii.Jsii.Proxy(Behavior.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Behavior extends software.amazon.jsii.JsiiSerializable {

    /**
     * The method this CloudFront distribution responds do.
     * <p>
     * Default: GET_HEAD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods getAllowedMethods() {
        return null;
    }

    /**
     * Which methods are cached by CloudFront by default.
     * <p>
     * Default: GET_HEAD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods getCachedMethods() {
        return null;
    }

    /**
     * If CloudFront should automatically compress some content types.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCompress() {
        return null;
    }

    /**
     * The default amount of time CloudFront will cache an object.
     * <p>
     * This value applies only when your custom origin does not add HTTP headers,
     * such as Cache-Control max-age, Cache-Control s-maxage, and Expires to objects.
     * <p>
     * Default: 86400 (1 day)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getDefaultTtl() {
        return null;
    }

    /**
     * The values CloudFront will forward to the origin when making a request.
     * <p>
     * Default: none (no cookies - no headers)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty getForwardedValues() {
        return null;
    }

    /**
     * If this behavior is the default behavior for the distribution.
     * <p>
     * You must specify exactly one default distribution per CloudFront distribution.
     * The default behavior is allowed to omit the "path" property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIsDefaultBehavior() {
        return null;
    }

    /**
     * Declares associated lambda@edge functions for this distribution behaviour.
     * <p>
     * Default: No lambda function associated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation> getLambdaFunctionAssociations() {
        return null;
    }

    /**
     * The max amount of time you want objects to stay in the cache before CloudFront queries your origin.
     * <p>
     * Default: Duration.seconds(31536000) (one year)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getMaxTtl() {
        return null;
    }

    /**
     * The minimum amount of time that you want objects to stay in the cache before CloudFront queries your origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getMinTtl() {
        return null;
    }

    /**
     * The path this behavior responds to.
     * <p>
     * Required for all non-default behaviors. (The default behavior implicitly has "*" as the path pattern. )
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPathPattern() {
        return null;
    }

    /**
     * A list of Key Groups that CloudFront can use to validate signed URLs or signed cookies.
     * <p>
     * Default: - no KeyGroups are associated with cache behavior
     * <p>
     * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> getTrustedKeyGroups() {
        return null;
    }

    /**
     * (deprecated) Trusted signers is how CloudFront allows you to serve private content.
     * <p>
     * The signers are the account IDs that are allowed to sign cookies/presigned URLs for this distribution.
     * <p>
     * If you pass a non empty value, all requests for this behavior must be signed (no public access will be allowed)
     * <p>
     * @deprecated - We recommend using trustedKeyGroups instead of trustedSigners.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedSigners() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Behavior}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Behavior}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Behavior> {
        private software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods allowedMethods;
        private software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods cachedMethods;
        private java.lang.Boolean compress;
        private software.amazon.awscdk.core.Duration defaultTtl;
        private software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues;
        private java.lang.Boolean isDefaultBehavior;
        private java.util.List<software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation> lambdaFunctionAssociations;
        private software.amazon.awscdk.core.Duration maxTtl;
        private software.amazon.awscdk.core.Duration minTtl;
        private java.lang.String pathPattern;
        private java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups;
        private java.util.List<java.lang.String> trustedSigners;

        /**
         * Sets the value of {@link Behavior#getAllowedMethods}
         * @param allowedMethods The method this CloudFront distribution responds do.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedMethods(software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getCachedMethods}
         * @param cachedMethods Which methods are cached by CloudFront by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachedMethods(software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods cachedMethods) {
            this.cachedMethods = cachedMethods;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getCompress}
         * @param compress If CloudFront should automatically compress some content types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compress(java.lang.Boolean compress) {
            this.compress = compress;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getDefaultTtl}
         * @param defaultTtl The default amount of time CloudFront will cache an object.
         *                   This value applies only when your custom origin does not add HTTP headers,
         *                   such as Cache-Control max-age, Cache-Control s-maxage, and Expires to objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultTtl(software.amazon.awscdk.core.Duration defaultTtl) {
            this.defaultTtl = defaultTtl;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getForwardedValues}
         * @param forwardedValues The values CloudFront will forward to the origin when making a request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forwardedValues(software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues) {
            this.forwardedValues = forwardedValues;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getIsDefaultBehavior}
         * @param isDefaultBehavior If this behavior is the default behavior for the distribution.
         *                          You must specify exactly one default distribution per CloudFront distribution.
         *                          The default behavior is allowed to omit the "path" property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isDefaultBehavior(java.lang.Boolean isDefaultBehavior) {
            this.isDefaultBehavior = isDefaultBehavior;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getLambdaFunctionAssociations}
         * @param lambdaFunctionAssociations Declares associated lambda@edge functions for this distribution behaviour.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder lambdaFunctionAssociations(java.util.List<? extends software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation> lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = (java.util.List<software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation>)lambdaFunctionAssociations;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getMaxTtl}
         * @param maxTtl The max amount of time you want objects to stay in the cache before CloudFront queries your origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxTtl(software.amazon.awscdk.core.Duration maxTtl) {
            this.maxTtl = maxTtl;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getMinTtl}
         * @param minTtl The minimum amount of time that you want objects to stay in the cache before CloudFront queries your origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minTtl(software.amazon.awscdk.core.Duration minTtl) {
            this.minTtl = minTtl;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getPathPattern}
         * @param pathPattern The path this behavior responds to.
         *                    Required for all non-default behaviors. (The default behavior implicitly has "*" as the path pattern. )
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathPattern(java.lang.String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getTrustedKeyGroups}
         * @param trustedKeyGroups A list of Key Groups that CloudFront can use to validate signed URLs or signed cookies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder trustedKeyGroups(java.util.List<? extends software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups) {
            this.trustedKeyGroups = (java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup>)trustedKeyGroups;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getTrustedSigners}
         * @param trustedSigners Trusted signers is how CloudFront allows you to serve private content.
         *                       The signers are the account IDs that are allowed to sign cookies/presigned URLs for this distribution.
         *                       <p>
         *                       If you pass a non empty value, all requests for this behavior must be signed (no public access will be allowed)
         * @return {@code this}
         * @deprecated - We recommend using trustedKeyGroups instead of trustedSigners.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder trustedSigners(java.util.List<java.lang.String> trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Behavior}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Behavior build() {
            return new Jsii$Proxy(allowedMethods, cachedMethods, compress, defaultTtl, forwardedValues, isDefaultBehavior, lambdaFunctionAssociations, maxTtl, minTtl, pathPattern, trustedKeyGroups, trustedSigners);
        }
    }

    /**
     * An implementation for {@link Behavior}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Behavior {
        private final software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods allowedMethods;
        private final software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods cachedMethods;
        private final java.lang.Boolean compress;
        private final software.amazon.awscdk.core.Duration defaultTtl;
        private final software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues;
        private final java.lang.Boolean isDefaultBehavior;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation> lambdaFunctionAssociations;
        private final software.amazon.awscdk.core.Duration maxTtl;
        private final software.amazon.awscdk.core.Duration minTtl;
        private final java.lang.String pathPattern;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups;
        private final java.util.List<java.lang.String> trustedSigners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedMethods = software.amazon.jsii.Kernel.get(this, "allowedMethods", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods.class));
            this.cachedMethods = software.amazon.jsii.Kernel.get(this, "cachedMethods", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods.class));
            this.compress = software.amazon.jsii.Kernel.get(this, "compress", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.defaultTtl = software.amazon.jsii.Kernel.get(this, "defaultTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.forwardedValues = software.amazon.jsii.Kernel.get(this, "forwardedValues", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty.class));
            this.isDefaultBehavior = software.amazon.jsii.Kernel.get(this, "isDefaultBehavior", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.lambdaFunctionAssociations = software.amazon.jsii.Kernel.get(this, "lambdaFunctionAssociations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation.class)));
            this.maxTtl = software.amazon.jsii.Kernel.get(this, "maxTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.minTtl = software.amazon.jsii.Kernel.get(this, "minTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.pathPattern = software.amazon.jsii.Kernel.get(this, "pathPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trustedKeyGroups = software.amazon.jsii.Kernel.get(this, "trustedKeyGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IKeyGroup.class)));
            this.trustedSigners = software.amazon.jsii.Kernel.get(this, "trustedSigners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods allowedMethods, final software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods cachedMethods, final java.lang.Boolean compress, final software.amazon.awscdk.core.Duration defaultTtl, final software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues, final java.lang.Boolean isDefaultBehavior, final java.util.List<? extends software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation> lambdaFunctionAssociations, final software.amazon.awscdk.core.Duration maxTtl, final software.amazon.awscdk.core.Duration minTtl, final java.lang.String pathPattern, final java.util.List<? extends software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups, final java.util.List<java.lang.String> trustedSigners) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedMethods = allowedMethods;
            this.cachedMethods = cachedMethods;
            this.compress = compress;
            this.defaultTtl = defaultTtl;
            this.forwardedValues = forwardedValues;
            this.isDefaultBehavior = isDefaultBehavior;
            this.lambdaFunctionAssociations = (java.util.List<software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation>)lambdaFunctionAssociations;
            this.maxTtl = maxTtl;
            this.minTtl = minTtl;
            this.pathPattern = pathPattern;
            this.trustedKeyGroups = (java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup>)trustedKeyGroups;
            this.trustedSigners = trustedSigners;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods getCachedMethods() {
            return this.cachedMethods;
        }

        @Override
        public final java.lang.Boolean getCompress() {
            return this.compress;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getDefaultTtl() {
            return this.defaultTtl;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty getForwardedValues() {
            return this.forwardedValues;
        }

        @Override
        public final java.lang.Boolean getIsDefaultBehavior() {
            return this.isDefaultBehavior;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation> getLambdaFunctionAssociations() {
            return this.lambdaFunctionAssociations;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMaxTtl() {
            return this.maxTtl;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMinTtl() {
            return this.minTtl;
        }

        @Override
        public final java.lang.String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> getTrustedKeyGroups() {
            return this.trustedKeyGroups;
        }

        @Override
        public final java.util.List<java.lang.String> getTrustedSigners() {
            return this.trustedSigners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowedMethods() != null) {
                data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
            }
            if (this.getCachedMethods() != null) {
                data.set("cachedMethods", om.valueToTree(this.getCachedMethods()));
            }
            if (this.getCompress() != null) {
                data.set("compress", om.valueToTree(this.getCompress()));
            }
            if (this.getDefaultTtl() != null) {
                data.set("defaultTtl", om.valueToTree(this.getDefaultTtl()));
            }
            if (this.getForwardedValues() != null) {
                data.set("forwardedValues", om.valueToTree(this.getForwardedValues()));
            }
            if (this.getIsDefaultBehavior() != null) {
                data.set("isDefaultBehavior", om.valueToTree(this.getIsDefaultBehavior()));
            }
            if (this.getLambdaFunctionAssociations() != null) {
                data.set("lambdaFunctionAssociations", om.valueToTree(this.getLambdaFunctionAssociations()));
            }
            if (this.getMaxTtl() != null) {
                data.set("maxTtl", om.valueToTree(this.getMaxTtl()));
            }
            if (this.getMinTtl() != null) {
                data.set("minTtl", om.valueToTree(this.getMinTtl()));
            }
            if (this.getPathPattern() != null) {
                data.set("pathPattern", om.valueToTree(this.getPathPattern()));
            }
            if (this.getTrustedKeyGroups() != null) {
                data.set("trustedKeyGroups", om.valueToTree(this.getTrustedKeyGroups()));
            }
            if (this.getTrustedSigners() != null) {
                data.set("trustedSigners", om.valueToTree(this.getTrustedSigners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.Behavior"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Behavior.Jsii$Proxy that = (Behavior.Jsii$Proxy) o;

            if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
            if (this.cachedMethods != null ? !this.cachedMethods.equals(that.cachedMethods) : that.cachedMethods != null) return false;
            if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
            if (this.defaultTtl != null ? !this.defaultTtl.equals(that.defaultTtl) : that.defaultTtl != null) return false;
            if (this.forwardedValues != null ? !this.forwardedValues.equals(that.forwardedValues) : that.forwardedValues != null) return false;
            if (this.isDefaultBehavior != null ? !this.isDefaultBehavior.equals(that.isDefaultBehavior) : that.isDefaultBehavior != null) return false;
            if (this.lambdaFunctionAssociations != null ? !this.lambdaFunctionAssociations.equals(that.lambdaFunctionAssociations) : that.lambdaFunctionAssociations != null) return false;
            if (this.maxTtl != null ? !this.maxTtl.equals(that.maxTtl) : that.maxTtl != null) return false;
            if (this.minTtl != null ? !this.minTtl.equals(that.minTtl) : that.minTtl != null) return false;
            if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) return false;
            if (this.trustedKeyGroups != null ? !this.trustedKeyGroups.equals(that.trustedKeyGroups) : that.trustedKeyGroups != null) return false;
            return this.trustedSigners != null ? this.trustedSigners.equals(that.trustedSigners) : that.trustedSigners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowedMethods != null ? this.allowedMethods.hashCode() : 0;
            result = 31 * result + (this.cachedMethods != null ? this.cachedMethods.hashCode() : 0);
            result = 31 * result + (this.compress != null ? this.compress.hashCode() : 0);
            result = 31 * result + (this.defaultTtl != null ? this.defaultTtl.hashCode() : 0);
            result = 31 * result + (this.forwardedValues != null ? this.forwardedValues.hashCode() : 0);
            result = 31 * result + (this.isDefaultBehavior != null ? this.isDefaultBehavior.hashCode() : 0);
            result = 31 * result + (this.lambdaFunctionAssociations != null ? this.lambdaFunctionAssociations.hashCode() : 0);
            result = 31 * result + (this.maxTtl != null ? this.maxTtl.hashCode() : 0);
            result = 31 * result + (this.minTtl != null ? this.minTtl.hashCode() : 0);
            result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
            result = 31 * result + (this.trustedKeyGroups != null ? this.trustedKeyGroups.hashCode() : 0);
            result = 31 * result + (this.trustedSigners != null ? this.trustedSigners.hashCode() : 0);
            return result;
        }
    }
}
