package software.amazon.awscdk.services.cloudfront;

/**
 * Determines whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:46:52.397Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CacheCookieBehavior")
public class CacheCookieBehavior extends software.amazon.jsii.JsiiObject {

    protected CacheCookieBehavior(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CacheCookieBehavior(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * All cookies in viewer requests are included in the cache key and are automatically included in requests that CloudFront sends to the origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheCookieBehavior all() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class, "all", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class));
    }

    /**
     * Only the provided `cookies` are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     * <p>
     * @param cookies This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheCookieBehavior allowList(final @org.jetbrains.annotations.NotNull java.lang.String... cookies) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class, "allowList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class), java.util.Arrays.<Object>stream(cookies).toArray(Object[]::new));
    }

    /**
     * All cookies except the provided `cookies` are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     * <p>
     * @param cookies This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheCookieBehavior denyList(final @org.jetbrains.annotations.NotNull java.lang.String... cookies) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class, "denyList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class), java.util.Arrays.<Object>stream(cookies).toArray(Object[]::new));
    }

    /**
     * Cookies in viewer requests are not included in the cache key and are not automatically included in requests that CloudFront sends to the origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheCookieBehavior none() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class, "none", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class));
    }

    /**
     * The behavior of cookies: allow all, none, an allow list, or a deny list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBehavior() {
        return software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The cookies to allow or deny, if the behavior is an allow or deny list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCookies() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "cookies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
}
