package software.amazon.awscdk.services.cloudfront;

/**
 * Controls the countries in which content is distributed.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:46:52.426Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.GeoRestriction")
public class GeoRestriction extends software.amazon.jsii.JsiiObject {

    protected GeoRestriction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GeoRestriction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Blacklist specific countries which you don't want CloudFront to distribute your content.
     * <p>
     * @param locations Two-letter, uppercase country code for a country that you want to blacklist. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.GeoRestriction blacklist(final @org.jetbrains.annotations.NotNull java.lang.String... locations) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.GeoRestriction.class, "blacklist", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.GeoRestriction.class), java.util.Arrays.<Object>stream(locations).toArray(Object[]::new));
    }

    /**
     * Whitelist specific countries which you want CloudFront to distribute your content.
     * <p>
     * @param locations Two-letter, uppercase country code for a country that you want to whitelist. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.GeoRestriction whitelist(final @org.jetbrains.annotations.NotNull java.lang.String... locations) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.GeoRestriction.class, "whitelist", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.GeoRestriction.class), java.util.Arrays.<Object>stream(locations).toArray(Object[]::new));
    }

    /**
     * Two-letter, uppercase country code for a country that you want to whitelist/blacklist.
     * <p>
     * Include one element for each country.
     * See ISO 3166-1-alpha-2 code on the <em>International Organization for Standardization</em> website
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getLocations() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "locations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Specifies the restriction type to impose (whitelist or blacklist).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestrictionType() {
        return software.amazon.jsii.Kernel.get(this, "restrictionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
