package software.amazon.awscdk.services.cloudfront;

/**
 * Determines whether any HTTP headers (and if so, which headers) are included in requests that CloudFront sends to the origin.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:46:52.430Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.OriginRequestHeaderBehavior")
public class OriginRequestHeaderBehavior extends software.amazon.jsii.JsiiObject {

    protected OriginRequestHeaderBehavior(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OriginRequestHeaderBehavior(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin.
     * <p>
     * Additionally, any additional CloudFront headers provided are included; the additional headers are added by CloudFront.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-cloudfront-headers.html
     * @param cloudfrontHeaders This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior all(final @org.jetbrains.annotations.NotNull java.lang.String... cloudfrontHeaders) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior.class, "all", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior.class), java.util.Arrays.<Object>stream(cloudfrontHeaders).toArray(Object[]::new));
    }

    /**
     * Listed headers are included in requests that CloudFront sends to the origin.
     * <p>
     * @param headers This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior allowList(final @org.jetbrains.annotations.NotNull java.lang.String... headers) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior.class, "allowList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior.class), java.util.Arrays.<Object>stream(headers).toArray(Object[]::new));
    }

    /**
     * HTTP headers are not included in requests that CloudFront sends to the origin.
     * <p>
     * Any headers that are listed in a CachePolicy are still included in origin requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior none() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior.class, "none", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior.class));
    }

    /**
     * The behavior of headers: allow all, none or an allow list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBehavior() {
        return software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The headers for the allow list or the included CloudFront headers, if applicable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeaders() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
}
