package software.amazon.awscdk.services.cloudfront;

/**
 * A source configuration is a wrapper for CloudFront origins and behaviors.
 * <p>
 * An origin is what CloudFront will "be in front of" - that is, CloudFront will pull it's assets from an origin.
 * <p>
 * If you're using s3 as a source - pass the <code>s3Origin</code> property, otherwise, pass the <code>customOriginSource</code> property.
 * <p>
 * One or the other must be passed, and it is invalid to pass both in the same SourceConfiguration.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:46:52.432Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.SourceConfiguration")
@software.amazon.jsii.Jsii.Proxy(SourceConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SourceConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * The behaviors associated with this source.
     * <p>
     * At least one (default) behavior must be included.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cloudfront.Behavior> getBehaviors();

    /**
     * The number of times that CloudFront attempts to connect to the origin.
     * <p>
     * You can specify 1, 2, or 3 as the number of attempts.
     * <p>
     * Default: 3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getConnectionAttempts() {
        return null;
    }

    /**
     * The number of seconds that CloudFront waits when trying to establish a connection to the origin.
     * <p>
     * You can specify a number of seconds between 1 and 10 (inclusive).
     * <p>
     * Default: cdk.Duration.seconds(10)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getConnectionTimeout() {
        return null;
    }

    /**
     * A custom origin source - for all non-s3 sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CustomOriginConfig getCustomOriginSource() {
        return null;
    }

    /**
     * HTTP status code to failover to second origin.
     * <p>
     * Default: [500, 502, 503, 504]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.FailoverStatusCode> getFailoverCriteriaStatusCodes() {
        return null;
    }

    /**
     * A custom origin source for failover in case the s3OriginSource returns invalid status code.
     * <p>
     * Default: - no failover configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CustomOriginConfig getFailoverCustomOriginSource() {
        return null;
    }

    /**
     * An s3 origin source for failover in case the s3OriginSource returns invalid status code.
     * <p>
     * Default: - no failover configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.S3OriginConfig getFailoverS3OriginSource() {
        return null;
    }

    /**
     * (deprecated) Any additional headers to pass to the origin.
     * <p>
     * Default: - No additional headers are passed.
     * <p>
     * @deprecated Use originHeaders on s3OriginSource or customOriginSource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getOriginHeaders() {
        return null;
    }

    /**
     * (deprecated) The relative path to the origin root to use for sources.
     * <p>
     * Default: /
     * <p>
     * @deprecated Use originPath on s3OriginSource or customOriginSource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getOriginPath() {
        return null;
    }

    /**
     * An s3 origin source - if you're using s3 for your assets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.S3OriginConfig getS3OriginSource() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SourceConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SourceConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SourceConfiguration> {
        private java.util.List<software.amazon.awscdk.services.cloudfront.Behavior> behaviors;
        private java.lang.Number connectionAttempts;
        private software.amazon.awscdk.core.Duration connectionTimeout;
        private software.amazon.awscdk.services.cloudfront.CustomOriginConfig customOriginSource;
        private java.util.List<software.amazon.awscdk.services.cloudfront.FailoverStatusCode> failoverCriteriaStatusCodes;
        private software.amazon.awscdk.services.cloudfront.CustomOriginConfig failoverCustomOriginSource;
        private software.amazon.awscdk.services.cloudfront.S3OriginConfig failoverS3OriginSource;
        private java.util.Map<java.lang.String, java.lang.String> originHeaders;
        private java.lang.String originPath;
        private software.amazon.awscdk.services.cloudfront.S3OriginConfig s3OriginSource;

        /**
         * Sets the value of {@link SourceConfiguration#getBehaviors}
         * @param behaviors The behaviors associated with this source. This parameter is required.
         *                  At least one (default) behavior must be included.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder behaviors(java.util.List<? extends software.amazon.awscdk.services.cloudfront.Behavior> behaviors) {
            this.behaviors = (java.util.List<software.amazon.awscdk.services.cloudfront.Behavior>)behaviors;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfiguration#getConnectionAttempts}
         * @param connectionAttempts The number of times that CloudFront attempts to connect to the origin.
         *                           You can specify 1, 2, or 3 as the number of attempts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionAttempts(java.lang.Number connectionAttempts) {
            this.connectionAttempts = connectionAttempts;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfiguration#getConnectionTimeout}
         * @param connectionTimeout The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         *                          You can specify a number of seconds between 1 and 10 (inclusive).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionTimeout(software.amazon.awscdk.core.Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfiguration#getCustomOriginSource}
         * @param customOriginSource A custom origin source - for all non-s3 sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customOriginSource(software.amazon.awscdk.services.cloudfront.CustomOriginConfig customOriginSource) {
            this.customOriginSource = customOriginSource;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfiguration#getFailoverCriteriaStatusCodes}
         * @param failoverCriteriaStatusCodes HTTP status code to failover to second origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder failoverCriteriaStatusCodes(java.util.List<? extends software.amazon.awscdk.services.cloudfront.FailoverStatusCode> failoverCriteriaStatusCodes) {
            this.failoverCriteriaStatusCodes = (java.util.List<software.amazon.awscdk.services.cloudfront.FailoverStatusCode>)failoverCriteriaStatusCodes;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfiguration#getFailoverCustomOriginSource}
         * @param failoverCustomOriginSource A custom origin source for failover in case the s3OriginSource returns invalid status code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failoverCustomOriginSource(software.amazon.awscdk.services.cloudfront.CustomOriginConfig failoverCustomOriginSource) {
            this.failoverCustomOriginSource = failoverCustomOriginSource;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfiguration#getFailoverS3OriginSource}
         * @param failoverS3OriginSource An s3 origin source for failover in case the s3OriginSource returns invalid status code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failoverS3OriginSource(software.amazon.awscdk.services.cloudfront.S3OriginConfig failoverS3OriginSource) {
            this.failoverS3OriginSource = failoverS3OriginSource;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfiguration#getOriginHeaders}
         * @param originHeaders Any additional headers to pass to the origin.
         * @return {@code this}
         * @deprecated Use originHeaders on s3OriginSource or customOriginSource
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder originHeaders(java.util.Map<java.lang.String, java.lang.String> originHeaders) {
            this.originHeaders = originHeaders;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfiguration#getOriginPath}
         * @param originPath The relative path to the origin root to use for sources.
         * @return {@code this}
         * @deprecated Use originPath on s3OriginSource or customOriginSource
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder originPath(java.lang.String originPath) {
            this.originPath = originPath;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfiguration#getS3OriginSource}
         * @param s3OriginSource An s3 origin source - if you're using s3 for your assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3OriginSource(software.amazon.awscdk.services.cloudfront.S3OriginConfig s3OriginSource) {
            this.s3OriginSource = s3OriginSource;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SourceConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SourceConfiguration build() {
            return new Jsii$Proxy(behaviors, connectionAttempts, connectionTimeout, customOriginSource, failoverCriteriaStatusCodes, failoverCustomOriginSource, failoverS3OriginSource, originHeaders, originPath, s3OriginSource);
        }
    }

    /**
     * An implementation for {@link SourceConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConfiguration {
        private final java.util.List<software.amazon.awscdk.services.cloudfront.Behavior> behaviors;
        private final java.lang.Number connectionAttempts;
        private final software.amazon.awscdk.core.Duration connectionTimeout;
        private final software.amazon.awscdk.services.cloudfront.CustomOriginConfig customOriginSource;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.FailoverStatusCode> failoverCriteriaStatusCodes;
        private final software.amazon.awscdk.services.cloudfront.CustomOriginConfig failoverCustomOriginSource;
        private final software.amazon.awscdk.services.cloudfront.S3OriginConfig failoverS3OriginSource;
        private final java.util.Map<java.lang.String, java.lang.String> originHeaders;
        private final java.lang.String originPath;
        private final software.amazon.awscdk.services.cloudfront.S3OriginConfig s3OriginSource;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.behaviors = software.amazon.jsii.Kernel.get(this, "behaviors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.Behavior.class)));
            this.connectionAttempts = software.amazon.jsii.Kernel.get(this, "connectionAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.connectionTimeout = software.amazon.jsii.Kernel.get(this, "connectionTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.customOriginSource = software.amazon.jsii.Kernel.get(this, "customOriginSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CustomOriginConfig.class));
            this.failoverCriteriaStatusCodes = software.amazon.jsii.Kernel.get(this, "failoverCriteriaStatusCodes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FailoverStatusCode.class)));
            this.failoverCustomOriginSource = software.amazon.jsii.Kernel.get(this, "failoverCustomOriginSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CustomOriginConfig.class));
            this.failoverS3OriginSource = software.amazon.jsii.Kernel.get(this, "failoverS3OriginSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.S3OriginConfig.class));
            this.originHeaders = software.amazon.jsii.Kernel.get(this, "originHeaders", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.originPath = software.amazon.jsii.Kernel.get(this, "originPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3OriginSource = software.amazon.jsii.Kernel.get(this, "s3OriginSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.S3OriginConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.util.List<? extends software.amazon.awscdk.services.cloudfront.Behavior> behaviors, final java.lang.Number connectionAttempts, final software.amazon.awscdk.core.Duration connectionTimeout, final software.amazon.awscdk.services.cloudfront.CustomOriginConfig customOriginSource, final java.util.List<? extends software.amazon.awscdk.services.cloudfront.FailoverStatusCode> failoverCriteriaStatusCodes, final software.amazon.awscdk.services.cloudfront.CustomOriginConfig failoverCustomOriginSource, final software.amazon.awscdk.services.cloudfront.S3OriginConfig failoverS3OriginSource, final java.util.Map<java.lang.String, java.lang.String> originHeaders, final java.lang.String originPath, final software.amazon.awscdk.services.cloudfront.S3OriginConfig s3OriginSource) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.behaviors = (java.util.List<software.amazon.awscdk.services.cloudfront.Behavior>)java.util.Objects.requireNonNull(behaviors, "behaviors is required");
            this.connectionAttempts = connectionAttempts;
            this.connectionTimeout = connectionTimeout;
            this.customOriginSource = customOriginSource;
            this.failoverCriteriaStatusCodes = (java.util.List<software.amazon.awscdk.services.cloudfront.FailoverStatusCode>)failoverCriteriaStatusCodes;
            this.failoverCustomOriginSource = failoverCustomOriginSource;
            this.failoverS3OriginSource = failoverS3OriginSource;
            this.originHeaders = originHeaders;
            this.originPath = originPath;
            this.s3OriginSource = s3OriginSource;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.Behavior> getBehaviors() {
            return this.behaviors;
        }

        @Override
        public final java.lang.Number getConnectionAttempts() {
            return this.connectionAttempts;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CustomOriginConfig getCustomOriginSource() {
            return this.customOriginSource;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.FailoverStatusCode> getFailoverCriteriaStatusCodes() {
            return this.failoverCriteriaStatusCodes;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CustomOriginConfig getFailoverCustomOriginSource() {
            return this.failoverCustomOriginSource;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.S3OriginConfig getFailoverS3OriginSource() {
            return this.failoverS3OriginSource;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getOriginHeaders() {
            return this.originHeaders;
        }

        @Override
        public final java.lang.String getOriginPath() {
            return this.originPath;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.S3OriginConfig getS3OriginSource() {
            return this.s3OriginSource;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("behaviors", om.valueToTree(this.getBehaviors()));
            if (this.getConnectionAttempts() != null) {
                data.set("connectionAttempts", om.valueToTree(this.getConnectionAttempts()));
            }
            if (this.getConnectionTimeout() != null) {
                data.set("connectionTimeout", om.valueToTree(this.getConnectionTimeout()));
            }
            if (this.getCustomOriginSource() != null) {
                data.set("customOriginSource", om.valueToTree(this.getCustomOriginSource()));
            }
            if (this.getFailoverCriteriaStatusCodes() != null) {
                data.set("failoverCriteriaStatusCodes", om.valueToTree(this.getFailoverCriteriaStatusCodes()));
            }
            if (this.getFailoverCustomOriginSource() != null) {
                data.set("failoverCustomOriginSource", om.valueToTree(this.getFailoverCustomOriginSource()));
            }
            if (this.getFailoverS3OriginSource() != null) {
                data.set("failoverS3OriginSource", om.valueToTree(this.getFailoverS3OriginSource()));
            }
            if (this.getOriginHeaders() != null) {
                data.set("originHeaders", om.valueToTree(this.getOriginHeaders()));
            }
            if (this.getOriginPath() != null) {
                data.set("originPath", om.valueToTree(this.getOriginPath()));
            }
            if (this.getS3OriginSource() != null) {
                data.set("s3OriginSource", om.valueToTree(this.getS3OriginSource()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.SourceConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SourceConfiguration.Jsii$Proxy that = (SourceConfiguration.Jsii$Proxy) o;

            if (!behaviors.equals(that.behaviors)) return false;
            if (this.connectionAttempts != null ? !this.connectionAttempts.equals(that.connectionAttempts) : that.connectionAttempts != null) return false;
            if (this.connectionTimeout != null ? !this.connectionTimeout.equals(that.connectionTimeout) : that.connectionTimeout != null) return false;
            if (this.customOriginSource != null ? !this.customOriginSource.equals(that.customOriginSource) : that.customOriginSource != null) return false;
            if (this.failoverCriteriaStatusCodes != null ? !this.failoverCriteriaStatusCodes.equals(that.failoverCriteriaStatusCodes) : that.failoverCriteriaStatusCodes != null) return false;
            if (this.failoverCustomOriginSource != null ? !this.failoverCustomOriginSource.equals(that.failoverCustomOriginSource) : that.failoverCustomOriginSource != null) return false;
            if (this.failoverS3OriginSource != null ? !this.failoverS3OriginSource.equals(that.failoverS3OriginSource) : that.failoverS3OriginSource != null) return false;
            if (this.originHeaders != null ? !this.originHeaders.equals(that.originHeaders) : that.originHeaders != null) return false;
            if (this.originPath != null ? !this.originPath.equals(that.originPath) : that.originPath != null) return false;
            return this.s3OriginSource != null ? this.s3OriginSource.equals(that.s3OriginSource) : that.s3OriginSource == null;
        }

        @Override
        public final int hashCode() {
            int result = this.behaviors.hashCode();
            result = 31 * result + (this.connectionAttempts != null ? this.connectionAttempts.hashCode() : 0);
            result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
            result = 31 * result + (this.customOriginSource != null ? this.customOriginSource.hashCode() : 0);
            result = 31 * result + (this.failoverCriteriaStatusCodes != null ? this.failoverCriteriaStatusCodes.hashCode() : 0);
            result = 31 * result + (this.failoverCustomOriginSource != null ? this.failoverCustomOriginSource.hashCode() : 0);
            result = 31 * result + (this.failoverS3OriginSource != null ? this.failoverS3OriginSource.hashCode() : 0);
            result = 31 * result + (this.originHeaders != null ? this.originHeaders.hashCode() : 0);
            result = 31 * result + (this.originPath != null ? this.originPath.hashCode() : 0);
            result = 31 * result + (this.s3OriginSource != null ? this.s3OriginSource.hashCode() : 0);
            return result;
        }
    }
}
