/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.certificatemanager.ICertificate;
import software.amazon.awscdk.services.cloudfront.;
import software.amazon.awscdk.services.cloudfront.BehaviorOptions;
import software.amazon.awscdk.services.cloudfront.DistributionProps;
import software.amazon.awscdk.services.cloudfront.ErrorResponse;
import software.amazon.awscdk.services.cloudfront.GeoRestriction;
import software.amazon.awscdk.services.cloudfront.HttpVersion;
import software.amazon.awscdk.services.cloudfront.PriceClass;
import software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-cloudfront.DistributionProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface DistributionProps
extends JsiiSerializable {
    @NotNull
    public BehaviorOptions getDefaultBehavior();

    @Nullable
    default public Map<String, BehaviorOptions> getAdditionalBehaviors() {
        return null;
    }

    @Nullable
    default public ICertificate getCertificate() {
        return null;
    }

    @Nullable
    default public String getComment() {
        return null;
    }

    @Nullable
    default public String getDefaultRootObject() {
        return null;
    }

    @Nullable
    default public List<String> getDomainNames() {
        return null;
    }

    @Nullable
    default public Boolean getEnabled() {
        return null;
    }

    @Nullable
    default public Boolean getEnableIpv6() {
        return null;
    }

    @Nullable
    default public Boolean getEnableLogging() {
        return null;
    }

    @Nullable
    default public List<ErrorResponse> getErrorResponses() {
        return null;
    }

    @Nullable
    default public GeoRestriction getGeoRestriction() {
        return null;
    }

    @Nullable
    default public HttpVersion getHttpVersion() {
        return null;
    }

    @Nullable
    default public IBucket getLogBucket() {
        return null;
    }

    @Nullable
    default public String getLogFilePrefix() {
        return null;
    }

    @Nullable
    default public Boolean getLogIncludesCookies() {
        return null;
    }

    @Nullable
    default public SecurityPolicyProtocol getMinimumProtocolVersion() {
        return null;
    }

    @Nullable
    default public PriceClass getPriceClass() {
        return null;
    }

    @Nullable
    default public String getWebAclId() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DistributionProps> {
        private BehaviorOptions defaultBehavior;
        private Map<String, BehaviorOptions> additionalBehaviors;
        private ICertificate certificate;
        private String comment;
        private String defaultRootObject;
        private List<String> domainNames;
        private Boolean enabled;
        private Boolean enableIpv6;
        private Boolean enableLogging;
        private List<ErrorResponse> errorResponses;
        private GeoRestriction geoRestriction;
        private HttpVersion httpVersion;
        private IBucket logBucket;
        private String logFilePrefix;
        private Boolean logIncludesCookies;
        private SecurityPolicyProtocol minimumProtocolVersion;
        private PriceClass priceClass;
        private String webAclId;

        public Builder defaultBehavior(BehaviorOptions defaultBehavior) {
            this.defaultBehavior = defaultBehavior;
            return this;
        }

        public Builder additionalBehaviors(Map<String, ? extends BehaviorOptions> additionalBehaviors) {
            this.additionalBehaviors = additionalBehaviors;
            return this;
        }

        public Builder certificate(ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder defaultRootObject(String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
            return this;
        }

        public Builder domainNames(List<String> domainNames) {
            this.domainNames = domainNames;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enableIpv6(Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
            return this;
        }

        public Builder enableLogging(Boolean enableLogging) {
            this.enableLogging = enableLogging;
            return this;
        }

        public Builder errorResponses(List<? extends ErrorResponse> errorResponses) {
            this.errorResponses = errorResponses;
            return this;
        }

        public Builder geoRestriction(GeoRestriction geoRestriction) {
            this.geoRestriction = geoRestriction;
            return this;
        }

        public Builder httpVersion(HttpVersion httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        public Builder logBucket(IBucket logBucket) {
            this.logBucket = logBucket;
            return this;
        }

        public Builder logFilePrefix(String logFilePrefix) {
            this.logFilePrefix = logFilePrefix;
            return this;
        }

        public Builder logIncludesCookies(Boolean logIncludesCookies) {
            this.logIncludesCookies = logIncludesCookies;
            return this;
        }

        public Builder minimumProtocolVersion(SecurityPolicyProtocol minimumProtocolVersion) {
            this.minimumProtocolVersion = minimumProtocolVersion;
            return this;
        }

        public Builder priceClass(PriceClass priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        public Builder webAclId(String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        public DistributionProps build() {
            return new Jsii.Proxy(this.defaultBehavior, this.additionalBehaviors, this.certificate, this.comment, this.defaultRootObject, this.domainNames, this.enabled, this.enableIpv6, this.enableLogging, this.errorResponses, this.geoRestriction, this.httpVersion, this.logBucket, this.logFilePrefix, this.logIncludesCookies, this.minimumProtocolVersion, this.priceClass, this.webAclId);
        }
    }
}

