package software.amazon.awscdk.services.cloudtrail;

/**
 * Properties for defining a `CfnEventDataStore`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudtrail.*;
 * CfnEventDataStoreProps cfnEventDataStoreProps = CfnEventDataStoreProps.builder()
 *         .advancedEventSelectors(List.of(AdvancedEventSelectorProperty.builder()
 *                 .fieldSelectors(List.of(AdvancedFieldSelectorProperty.builder()
 *                         .field("field")
 *                         // the properties below are optional
 *                         .endsWith(List.of("endsWith"))
 *                         .equalTo(List.of("equalTo"))
 *                         .notEndsWith(List.of("notEndsWith"))
 *                         .notEquals(List.of("notEquals"))
 *                         .notStartsWith(List.of("notStartsWith"))
 *                         .startsWith(List.of("startsWith"))
 *                         .build()))
 *                 // the properties below are optional
 *                 .name("name")
 *                 .build()))
 *         .kmsKeyId("kmsKeyId")
 *         .multiRegionEnabled(false)
 *         .name("name")
 *         .organizationEnabled(false)
 *         .retentionPeriod(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .terminationProtectionEnabled(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:42.147Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudtrail.$Module.class, fqn = "@aws-cdk/aws-cloudtrail.CfnEventDataStoreProps")
@software.amazon.jsii.Jsii.Proxy(CfnEventDataStoreProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEventDataStoreProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The advanced event selectors to use to select the events for the data store.
     * <p>
     * You can configure up to five advanced event selectors for each event data store.
     * <p>
     * For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
     * <p>
     * For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-cli-create-eds-config.html">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedEventSelectors() {
        return null;
    }

    /**
     * Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail.
     * <p>
     * The value can be an alias name prefixed by <code>alias/</code> , a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
     * <p>
     * <blockquote>
     * <p>
     * Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.
     * <p>
     * </blockquote>
     * <p>
     * CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * Examples:
     * <p>
     * <ul>
     * <li><code>alias/MyAliasName</code></li>
     * <li><code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code></li>
     * <li><code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code></li>
     * <li><code>12345678-1234-1234-1234-123456789012</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMultiRegionEnabled() {
        return null;
    }

    /**
     * The name of the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Specifies whether an event data store collects events logged for an organization in AWS Organizations .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationEnabled() {
        return null;
    }

    /**
     * The retention period of the event data store, in days.
     * <p>
     * You can set a retention period of up to 2557 days, the equivalent of seven years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetentionPeriod() {
        return null;
    }

    /**
     * A list of tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * Specifies whether termination protection is enabled for the event data store.
     * <p>
     * If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTerminationProtectionEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEventDataStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEventDataStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEventDataStoreProps> {
        java.lang.Object advancedEventSelectors;
        java.lang.String kmsKeyId;
        java.lang.Object multiRegionEnabled;
        java.lang.String name;
        java.lang.Object organizationEnabled;
        java.lang.Number retentionPeriod;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.Object terminationProtectionEnabled;

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getAdvancedEventSelectors}
         * @param advancedEventSelectors The advanced event selectors to use to select the events for the data store.
         *                               You can configure up to five advanced event selectors for each event data store.
         *                               <p>
         *                               For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         *                               <p>
         *                               For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-cli-create-eds-config.html">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(software.amazon.awscdk.core.IResolvable advancedEventSelectors) {
            this.advancedEventSelectors = advancedEventSelectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getAdvancedEventSelectors}
         * @param advancedEventSelectors The advanced event selectors to use to select the events for the data store.
         *                               You can configure up to five advanced event selectors for each event data store.
         *                               <p>
         *                               For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         *                               <p>
         *                               For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-cli-create-eds-config.html">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(java.util.List<? extends java.lang.Object> advancedEventSelectors) {
            this.advancedEventSelectors = advancedEventSelectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getKmsKeyId}
         * @param kmsKeyId Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail.
         *                 The value can be an alias name prefixed by <code>alias/</code> , a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
         *                 <p>
         *                 <blockquote>
         *                 <p>
         *                 Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.
         *                 <p>
         *                 </blockquote>
         *                 <p>
         *                 CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                 <p>
         *                 Examples:
         *                 <p>
         *                 <ul>
         *                 <li><code>alias/MyAliasName</code></li>
         *                 <li><code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code></li>
         *                 <li><code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code></li>
         *                 <li><code>12345678-1234-1234-1234-123456789012</code></li>
         *                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getMultiRegionEnabled}
         * @param multiRegionEnabled Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionEnabled(java.lang.Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getMultiRegionEnabled}
         * @param multiRegionEnabled Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionEnabled(software.amazon.awscdk.core.IResolvable multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getName}
         * @param name The name of the event data store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getOrganizationEnabled}
         * @param organizationEnabled Specifies whether an event data store collects events logged for an organization in AWS Organizations .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationEnabled(java.lang.Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getOrganizationEnabled}
         * @param organizationEnabled Specifies whether an event data store collects events logged for an organization in AWS Organizations .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationEnabled(software.amazon.awscdk.core.IResolvable organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getRetentionPeriod}
         * @param retentionPeriod The retention period of the event data store, in days.
         *                        You can set a retention period of up to 2557 days, the equivalent of seven years.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(java.lang.Number retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getTags}
         * @param tags A list of tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getTerminationProtectionEnabled}
         * @param terminationProtectionEnabled Specifies whether termination protection is enabled for the event data store.
         *                                     If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(java.lang.Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getTerminationProtectionEnabled}
         * @param terminationProtectionEnabled Specifies whether termination protection is enabled for the event data store.
         *                                     If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(software.amazon.awscdk.core.IResolvable terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEventDataStoreProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEventDataStoreProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEventDataStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEventDataStoreProps {
        private final java.lang.Object advancedEventSelectors;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object multiRegionEnabled;
        private final java.lang.String name;
        private final java.lang.Object organizationEnabled;
        private final java.lang.Number retentionPeriod;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Object terminationProtectionEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.advancedEventSelectors = software.amazon.jsii.Kernel.get(this, "advancedEventSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiRegionEnabled = software.amazon.jsii.Kernel.get(this, "multiRegionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.organizationEnabled = software.amazon.jsii.Kernel.get(this, "organizationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retentionPeriod = software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.terminationProtectionEnabled = software.amazon.jsii.Kernel.get(this, "terminationProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.advancedEventSelectors = builder.advancedEventSelectors;
            this.kmsKeyId = builder.kmsKeyId;
            this.multiRegionEnabled = builder.multiRegionEnabled;
            this.name = builder.name;
            this.organizationEnabled = builder.organizationEnabled;
            this.retentionPeriod = builder.retentionPeriod;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
        }

        @Override
        public final java.lang.Object getAdvancedEventSelectors() {
            return this.advancedEventSelectors;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getMultiRegionEnabled() {
            return this.multiRegionEnabled;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getOrganizationEnabled() {
            return this.organizationEnabled;
        }

        @Override
        public final java.lang.Number getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTerminationProtectionEnabled() {
            return this.terminationProtectionEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdvancedEventSelectors() != null) {
                data.set("advancedEventSelectors", om.valueToTree(this.getAdvancedEventSelectors()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getMultiRegionEnabled() != null) {
                data.set("multiRegionEnabled", om.valueToTree(this.getMultiRegionEnabled()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOrganizationEnabled() != null) {
                data.set("organizationEnabled", om.valueToTree(this.getOrganizationEnabled()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTerminationProtectionEnabled() != null) {
                data.set("terminationProtectionEnabled", om.valueToTree(this.getTerminationProtectionEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudtrail.CfnEventDataStoreProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEventDataStoreProps.Jsii$Proxy that = (CfnEventDataStoreProps.Jsii$Proxy) o;

            if (this.advancedEventSelectors != null ? !this.advancedEventSelectors.equals(that.advancedEventSelectors) : that.advancedEventSelectors != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.multiRegionEnabled != null ? !this.multiRegionEnabled.equals(that.multiRegionEnabled) : that.multiRegionEnabled != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.organizationEnabled != null ? !this.organizationEnabled.equals(that.organizationEnabled) : that.organizationEnabled != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.terminationProtectionEnabled != null ? this.terminationProtectionEnabled.equals(that.terminationProtectionEnabled) : that.terminationProtectionEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.advancedEventSelectors != null ? this.advancedEventSelectors.hashCode() : 0;
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.multiRegionEnabled != null ? this.multiRegionEnabled.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.organizationEnabled != null ? this.organizationEnabled.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.terminationProtectionEnabled != null ? this.terminationProtectionEnabled.hashCode() : 0);
            return result;
        }
    }
}
