package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Types of EC2 actions available.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Alarm must be configured with an EC2 per-instance metric
 * Alarm alarm;
 * // Attach a reboot when alarm triggers
 * alarm.addAlarmAction(
 * new Ec2Action(Ec2InstanceAction.REBOOT));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-02-24T23:24:28.168Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.actions.$Module.class, fqn = "@aws-cdk/aws-cloudwatch-actions.Ec2InstanceAction")
public enum Ec2InstanceAction {
    /**
     * Stop the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STOP,
    /**
     * Terminatethe instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TERMINATE,
    /**
     * Recover the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RECOVER,
    /**
     * Reboot the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REBOOT,
}
