package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Types of OpsItem severity available.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Alarm alarm;
 * // Create an OpsItem with specific severity and category when alarm triggers
 * alarm.addAlarmAction(
 * new SsmAction(OpsItemSeverity.CRITICAL, OpsItemCategory.PERFORMANCE));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-23T01:54:35.670Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.actions.$Module.class, fqn = "@aws-cdk/aws-cloudwatch-actions.OpsItemSeverity")
public enum OpsItemSeverity {
    /**
     * Set the severity to critical.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CRITICAL,
    /**
     * Set the severity to high.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH,
    /**
     * Set the severity to medium.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEDIUM,
    /**
     * Set the severity to low.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LOW,
}
