package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Use an SNS topic as an alarm action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.actions.*;
 * Alarm alarm;
 * Topic topic = new Topic(this, "Topic");
 * alarm.addAlarmAction(new SnsAction(topic));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-09T01:30:47.372Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.actions.$Module.class, fqn = "@aws-cdk/aws-cloudwatch-actions.SnsAction")
public class SnsAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IAlarmAction {

    protected SnsAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SnsAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param topic This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SnsAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(topic, "topic is required") });
    }

    /**
     * Returns an alarm action configuration to use an SNS topic as an alarm action.
     * <p>
     * @param _scope This parameter is required.
     * @param _alarm This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.AlarmActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm _alarm) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.AlarmActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_alarm, "_alarm is required") });
    }
}
