package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Use an AutoScaling StepScalingAction as an Alarm Action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.cloudwatch.actions.*;
 * StepScalingAction stepScalingAction;
 * AutoScalingAction autoScalingAction = new AutoScalingAction(stepScalingAction);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-10-06T13:25:07.847Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.actions.$Module.class, fqn = "@aws-cdk/aws-cloudwatch-actions.AutoScalingAction")
public class AutoScalingAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IAlarmAction {

    protected AutoScalingAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AutoScalingAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param stepScalingAction This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AutoScalingAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.StepScalingAction stepScalingAction) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stepScalingAction, "stepScalingAction is required") });
    }

    /**
     * Returns an alarm action configuration to use an AutoScaling StepScalingAction as an alarm action.
     * <p>
     * @param _scope This parameter is required.
     * @param _alarm This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.AlarmActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm _alarm) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.AlarmActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_alarm, "_alarm is required") });
    }
}
