package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Use an SSM OpsItem action as an Alarm action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Alarm alarm;
 * // Create an OpsItem with specific severity and category when alarm triggers
 * alarm.addAlarmAction(
 * new SsmAction(OpsItemSeverity.CRITICAL, OpsItemCategory.PERFORMANCE));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:47.598Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.actions.$Module.class, fqn = "@aws-cdk/aws-cloudwatch-actions.SsmAction")
public class SsmAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IAlarmAction {

    protected SsmAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SsmAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param severity This parameter is required.
     * @param category
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SsmAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.actions.OpsItemSeverity severity, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.actions.OpsItemCategory category) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(severity, "severity is required"), category });
    }

    /**
     * @param severity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SsmAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.actions.OpsItemSeverity severity) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(severity, "severity is required") });
    }

    /**
     * Returns an alarm action configuration to use an SSM OpsItem action as an alarm action.
     * <p>
     * @param _scope This parameter is required.
     * @param _alarm This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.AlarmActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm _alarm) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.AlarmActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_alarm, "_alarm is required") });
    }
}
