package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Types of EC2 actions available.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Alarm must be configured with an EC2 per-instance metric
 * Alarm alarm;
 * // Attach a reboot when alarm triggers
 * alarm.addAlarmAction(
 * new Ec2Action(Ec2InstanceAction.REBOOT));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-25T18:29:09.647Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.actions.$Module.class, fqn = "@aws-cdk/aws-cloudwatch-actions.Ec2InstanceAction")
public enum Ec2InstanceAction {
    /**
     * Stop the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STOP,
    /**
     * Terminatethe instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TERMINATE,
    /**
     * Recover the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RECOVER,
    /**
     * Reboot the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REBOOT,
}
