/**
 * <h1>CloudWatch Alarm Actions library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="End-of-Support" src="https://img.shields.io/badge/End--of--Support-critical.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * AWS CDK v1 has reached End-of-Support on 2023-06-01.
 * This package is no longer being updated, and users should migrate to AWS CDK v2.
 * <p>
 * For more information on how to migrate, see the <a href="https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html"><em>Migrating to AWS CDK v2</em> guide</a>.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This library contains a set of classes which can be used as CloudWatch Alarm actions.
 * <p>
 * The currently implemented actions are: EC2 Actions, SNS Actions, SSM OpsCenter Actions, Autoscaling Actions and Application Autoscaling Actions
 * <p>
 * <h2>EC2 Action Example</h2>
 * <p>
 * <blockquote><pre>
 * // Alarm must be configured with an EC2 per-instance metric
 * Alarm alarm;
 * 
 * // Attach a reboot when alarm triggers
 * alarm.addAlarmAction(
 * new Ec2Action(Ec2InstanceAction.REBOOT));
 * </pre></blockquote>
 * <p>
 * <h2>SSM OpsCenter Action Example</h2>
 * <p>
 * <blockquote><pre>
 * Alarm alarm;
 * 
 * // Create an OpsItem with specific severity and category when alarm triggers
 * alarm.addAlarmAction(
 * new SsmAction(OpsItemSeverity.CRITICAL, OpsItemCategory.PERFORMANCE));
 * </pre></blockquote>
 * <p>
 * See <code>&#64;aws-cdk/aws-cloudwatch</code> for more information.
 *
 * Deprecated: AWS CDK v1 has reached End-of-Support on 2023-06-01.
This package is no longer being updated, and users should migrate to AWS CDK v2.

For more information on how to migrate, see https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@Deprecated
package software.amazon.awscdk.services.cloudwatch.actions;
