package software.amazon.awscdk.services.cloudwatch;

/**
 * An alarm on a CloudWatch metric.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:58:11.734Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.Alarm")
public class Alarm extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.cloudwatch.IAlarm {
    protected Alarm(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Alarm(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.cloudwatch.AlarmProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.services.cloudwatch.IAlarm fromAlarmArn(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String alarmArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Alarm.class, "fromAlarmArn", software.amazon.awscdk.services.cloudwatch.IAlarm.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(alarmArn, "alarmArn is required") });
    }

    /**
     * Trigger this action if the alarm fires.
     * 
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addAlarmAction(final software.amazon.awscdk.services.cloudwatch.IAlarmAction... actions) {
        this.jsiiCall("addAlarmAction", Void.class, java.util.Arrays.<Object>stream(actions).toArray(Object[]::new));
    }

    /**
     * Trigger this action if there is insufficient data to evaluate the alarm.
     * 
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addInsufficientDataAction(final software.amazon.awscdk.services.cloudwatch.IAlarmAction... actions) {
        this.jsiiCall("addInsufficientDataAction", Void.class, java.util.Arrays.<Object>stream(actions).toArray(Object[]::new));
    }

    /**
     * Trigger this action if the alarm returns from breaching state into ok state.
     * 
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addOkAction(final software.amazon.awscdk.services.cloudwatch.IAlarmAction... actions) {
        this.jsiiCall("addOkAction", Void.class, java.util.Arrays.<Object>stream(actions).toArray(Object[]::new));
    }

    /**
     * Turn this alarm into a horizontal annotation.
     * 
     * This is useful if you want to represent an Alarm in a non-AlarmWidget.
     * An `AlarmWidget` can directly show an alarm, but it can only show a
     * single alarm and no other metrics. Instead, you can convert the alarm to
     * a HorizontalAnnotation and add it as an annotation to another graph.
     * 
     * This might be useful if:
     * 
     * - You want to show multiple alarms inside a single graph, for example if
     *    you have both a "small margin/long period" alarm as well as a
     *    "large margin/short period" alarm.
     * 
     * - You want to show an Alarm line in a graph with multiple metrics in it.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation toAnnotation() {
        return this.jsiiCall("toAnnotation", software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation.class);
    }

    /**
     * ARN of this alarm.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getAlarmArn() {
        return this.jsiiGet("alarmArn", java.lang.String.class);
    }

    /**
     * Name of this alarm.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getAlarmName() {
        return this.jsiiGet("alarmName", java.lang.String.class);
    }

    /**
     * The metric object this alarm was based on.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.IMetric getMetric() {
        return this.jsiiGet("metric", software.amazon.awscdk.services.cloudwatch.IMetric.class);
    }
}
