package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for Alarms.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:58:11.739Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AlarmProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.CreateAlarmOptions {
    /**
     * The metric to add the alarm on.
     * 
     * Metric objects can be obtained from most resources, or you can construct
     * custom Metric objects by instantiating one.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.cloudwatch.IMetric getMetric();

    /**
     * @return a {@link Builder} of {@link AlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private software.amazon.awscdk.services.cloudwatch.IMetric _metric;
        private java.lang.Number _evaluationPeriods;
        private java.lang.Number _threshold;
        @javax.annotation.Nullable
        private java.lang.Boolean _actionsEnabled;
        @javax.annotation.Nullable
        private java.lang.String _alarmDescription;
        @javax.annotation.Nullable
        private java.lang.String _alarmName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.cloudwatch.ComparisonOperator _comparisonOperator;
        @javax.annotation.Nullable
        private java.lang.Number _datapointsToAlarm;
        @javax.annotation.Nullable
        private java.lang.String _evaluateLowSampleCountPercentile;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _period;
        @javax.annotation.Nullable
        private java.lang.String _statistic;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.cloudwatch.TreatMissingData _treatMissingData;

        /**
         * Sets the value of Metric
         * @param value The metric to add the alarm on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMetric(final software.amazon.awscdk.services.cloudwatch.IMetric value) {
            this._metric = java.util.Objects.requireNonNull(value, "metric is required");
            return this;
        }
        /**
         * Sets the value of EvaluationPeriods
         * @param value The number of periods over which data is compared to the specified threshold.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEvaluationPeriods(final java.lang.Number value) {
            this._evaluationPeriods = java.util.Objects.requireNonNull(value, "evaluationPeriods is required");
            return this;
        }
        /**
         * Sets the value of Threshold
         * @param value The value against which the specified statistic is compared.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withThreshold(final java.lang.Number value) {
            this._threshold = java.util.Objects.requireNonNull(value, "threshold is required");
            return this;
        }
        /**
         * Sets the value of ActionsEnabled
         * @param value Whether the actions for this alarm are enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withActionsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._actionsEnabled = value;
            return this;
        }
        /**
         * Sets the value of AlarmDescription
         * @param value Description for the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withAlarmDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._alarmDescription = value;
            return this;
        }
        /**
         * Sets the value of AlarmName
         * @param value Name of the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withAlarmName(@javax.annotation.Nullable final java.lang.String value) {
            this._alarmName = value;
            return this;
        }
        /**
         * Sets the value of ComparisonOperator
         * @param value Comparison to use to check if metric is breaching.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withComparisonOperator(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.ComparisonOperator value) {
            this._comparisonOperator = value;
            return this;
        }
        /**
         * Sets the value of DatapointsToAlarm
         * @param value The number of datapoints that must be breaching to trigger the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDatapointsToAlarm(@javax.annotation.Nullable final java.lang.Number value) {
            this._datapointsToAlarm = value;
            return this;
        }
        /**
         * Sets the value of EvaluateLowSampleCountPercentile
         * @param value Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEvaluateLowSampleCountPercentile(@javax.annotation.Nullable final java.lang.String value) {
            this._evaluateLowSampleCountPercentile = value;
            return this;
        }
        /**
         * Sets the value of Period
         * @param value The period over which the specified statistic is applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPeriod(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._period = value;
            return this;
        }
        /**
         * Sets the value of Statistic
         * @param value What function to use for aggregating.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withStatistic(@javax.annotation.Nullable final java.lang.String value) {
            this._statistic = value;
            return this;
        }
        /**
         * Sets the value of TreatMissingData
         * @param value Sets how this alarm is to handle missing data points.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withTreatMissingData(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.TreatMissingData value) {
            this._treatMissingData = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AlarmProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public AlarmProps build() {
            return new AlarmProps() {
                private final software.amazon.awscdk.services.cloudwatch.IMetric $metric = java.util.Objects.requireNonNull(_metric, "metric is required");
                private final java.lang.Number $evaluationPeriods = java.util.Objects.requireNonNull(_evaluationPeriods, "evaluationPeriods is required");
                private final java.lang.Number $threshold = java.util.Objects.requireNonNull(_threshold, "threshold is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $actionsEnabled = _actionsEnabled;
                @javax.annotation.Nullable
                private final java.lang.String $alarmDescription = _alarmDescription;
                @javax.annotation.Nullable
                private final java.lang.String $alarmName = _alarmName;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.cloudwatch.ComparisonOperator $comparisonOperator = _comparisonOperator;
                @javax.annotation.Nullable
                private final java.lang.Number $datapointsToAlarm = _datapointsToAlarm;
                @javax.annotation.Nullable
                private final java.lang.String $evaluateLowSampleCountPercentile = _evaluateLowSampleCountPercentile;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $period = _period;
                @javax.annotation.Nullable
                private final java.lang.String $statistic = _statistic;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.cloudwatch.TreatMissingData $treatMissingData = _treatMissingData;

                @Override
                public software.amazon.awscdk.services.cloudwatch.IMetric getMetric() {
                    return this.$metric;
                }

                @Override
                public java.lang.Number getEvaluationPeriods() {
                    return this.$evaluationPeriods;
                }

                @Override
                public java.lang.Number getThreshold() {
                    return this.$threshold;
                }

                @Override
                public java.lang.Boolean getActionsEnabled() {
                    return this.$actionsEnabled;
                }

                @Override
                public java.lang.String getAlarmDescription() {
                    return this.$alarmDescription;
                }

                @Override
                public java.lang.String getAlarmName() {
                    return this.$alarmName;
                }

                @Override
                public software.amazon.awscdk.services.cloudwatch.ComparisonOperator getComparisonOperator() {
                    return this.$comparisonOperator;
                }

                @Override
                public java.lang.Number getDatapointsToAlarm() {
                    return this.$datapointsToAlarm;
                }

                @Override
                public java.lang.String getEvaluateLowSampleCountPercentile() {
                    return this.$evaluateLowSampleCountPercentile;
                }

                @Override
                public software.amazon.awscdk.core.Duration getPeriod() {
                    return this.$period;
                }

                @Override
                public java.lang.String getStatistic() {
                    return this.$statistic;
                }

                @Override
                public software.amazon.awscdk.services.cloudwatch.TreatMissingData getTreatMissingData() {
                    return this.$treatMissingData;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("metric", om.valueToTree(this.getMetric()));
                    obj.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
                    obj.set("threshold", om.valueToTree(this.getThreshold()));
                    if (this.getActionsEnabled() != null) {
                        obj.set("actionsEnabled", om.valueToTree(this.getActionsEnabled()));
                    }
                    if (this.getAlarmDescription() != null) {
                        obj.set("alarmDescription", om.valueToTree(this.getAlarmDescription()));
                    }
                    if (this.getAlarmName() != null) {
                        obj.set("alarmName", om.valueToTree(this.getAlarmName()));
                    }
                    if (this.getComparisonOperator() != null) {
                        obj.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                    }
                    if (this.getDatapointsToAlarm() != null) {
                        obj.set("datapointsToAlarm", om.valueToTree(this.getDatapointsToAlarm()));
                    }
                    if (this.getEvaluateLowSampleCountPercentile() != null) {
                        obj.set("evaluateLowSampleCountPercentile", om.valueToTree(this.getEvaluateLowSampleCountPercentile()));
                    }
                    if (this.getPeriod() != null) {
                        obj.set("period", om.valueToTree(this.getPeriod()));
                    }
                    if (this.getStatistic() != null) {
                        obj.set("statistic", om.valueToTree(this.getStatistic()));
                    }
                    if (this.getTreatMissingData() != null) {
                        obj.set("treatMissingData", om.valueToTree(this.getTreatMissingData()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.AlarmProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The metric to add the alarm on.
         * 
         * Metric objects can be obtained from most resources, or you can construct
         * custom Metric objects by instantiating one.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.cloudwatch.IMetric getMetric() {
            return this.jsiiGet("metric", software.amazon.awscdk.services.cloudwatch.IMetric.class);
        }

        /**
         * The number of periods over which data is compared to the specified threshold.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.Number getEvaluationPeriods() {
            return this.jsiiGet("evaluationPeriods", java.lang.Number.class);
        }

        /**
         * The value against which the specified statistic is compared.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.Number getThreshold() {
            return this.jsiiGet("threshold", java.lang.Number.class);
        }

        /**
         * Whether the actions for this alarm are enabled.
         * 
         * Default: true
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getActionsEnabled() {
            return this.jsiiGet("actionsEnabled", java.lang.Boolean.class);
        }

        /**
         * Description for the alarm.
         * 
         * Default: No description
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getAlarmDescription() {
            return this.jsiiGet("alarmDescription", java.lang.String.class);
        }

        /**
         * Name of the alarm.
         * 
         * Default: Automatically generated name
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getAlarmName() {
            return this.jsiiGet("alarmName", java.lang.String.class);
        }

        /**
         * Comparison to use to check if metric is breaching.
         * 
         * Default: GreaterThanOrEqualToThreshold
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.cloudwatch.ComparisonOperator getComparisonOperator() {
            return this.jsiiGet("comparisonOperator", software.amazon.awscdk.services.cloudwatch.ComparisonOperator.class);
        }

        /**
         * The number of datapoints that must be breaching to trigger the alarm.
         * 
         * This is used only if you are setting an "M
         * out of N" alarm. In that case, this value is the M. For more information, see Evaluating an Alarm in the Amazon
         * CloudWatch User Guide.
         * 
         * Default: ``evaluationPeriods``
         * 
         * EXPERIMENTAL
         * 
         * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getDatapointsToAlarm() {
            return this.jsiiGet("datapointsToAlarm", java.lang.Number.class);
        }

        /**
         * Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant.
         * 
         * Used only for alarms that are based on percentiles.
         * 
         * Default: - Not configured.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getEvaluateLowSampleCountPercentile() {
            return this.jsiiGet("evaluateLowSampleCountPercentile", java.lang.String.class);
        }

        /**
         * The period over which the specified statistic is applied.
         * 
         * Default: Duration.minutes(5)
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getPeriod() {
            return this.jsiiGet("period", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * What function to use for aggregating.
         * 
         * Can be one of the following:
         * 
         * - "Minimum" | "min"
         * - "Maximum" | "max"
         * - "Average" | "avg"
         * - "Sum" | "sum"
         * - "SampleCount | "n"
         * - "pNN.NN"
         * 
         * Default: Average
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getStatistic() {
            return this.jsiiGet("statistic", java.lang.String.class);
        }

        /**
         * Sets how this alarm is to handle missing data points.
         * 
         * Default: TreatMissingData.Missing
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.cloudwatch.TreatMissingData getTreatMissingData() {
            return this.jsiiGet("treatMissingData", software.amazon.awscdk.services.cloudwatch.TreatMissingData.class);
        }
    }
}
